/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.lang.function;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.lang.function.FunctionReference;
import ch.njol.skript.lang.function.Parameter;
import ch.njol.skript.util.Contract;
import ch.njol.skript.util.Utils;
import java.util.Collection;
import java.util.Collections;
import java.util.WeakHashMap;
import org.jetbrains.annotations.Nullable;

public class Signature<T> {
    @Nullable
    final String script;
    final String name;
    final Parameter<?>[] parameters;
    final boolean local;
    @Nullable
    final ClassInfo<T> returnType;
    final boolean single;
    final Collection<FunctionReference<?>> calls;
    @Nullable
    final String originClassPath;
    @Nullable
    final Contract contract;

    public Signature(String script, String name, Parameter<?>[] parameters, boolean local, @Nullable ClassInfo<T> returnType, boolean single, @Nullable String originClassPath, @Nullable Contract contract) {
        this.script = script;
        this.name = name;
        this.parameters = parameters;
        this.local = local;
        this.returnType = returnType;
        this.single = single;
        this.originClassPath = originClassPath;
        this.contract = contract;
        this.calls = Collections.newSetFromMap(new WeakHashMap());
    }

    public Signature(String script, String name, Parameter<?>[] parameters, boolean local, @Nullable ClassInfo<T> returnType, boolean single, @Nullable String originClassPath) {
        this(script, name, parameters, local, returnType, single, originClassPath, null);
    }

    public Signature(String script, String name, Parameter<?>[] parameters, boolean local, @Nullable ClassInfo<T> returnType, boolean single) {
        this(script, name, parameters, local, returnType, single, null);
    }

    public String getName() {
        return this.name;
    }

    public Parameter<?> getParameter(int index) {
        return this.parameters[index];
    }

    public Parameter<?>[] getParameters() {
        return this.parameters;
    }

    public boolean isLocal() {
        return this.local;
    }

    @Nullable
    public ClassInfo<T> getReturnType() {
        return this.returnType;
    }

    public boolean isSingle() {
        return this.single;
    }

    public String getOriginClassPath() {
        return this.originClassPath;
    }

    @Nullable
    public Contract getContract() {
        return this.contract;
    }

    public int getMaxParameters() {
        return this.parameters.length;
    }

    public int getMinParameters() {
        for (int i = this.parameters.length - 1; i >= 0; --i) {
            if (this.parameters[i].def != null) continue;
            return i + 1;
        }
        return 0;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.toString(true, Skript.debug());
    }

    public String toString(boolean includeReturnType, boolean debug) {
        StringBuilder signatureBuilder = new StringBuilder();
        if (this.local) {
            signatureBuilder.append("local ");
        }
        signatureBuilder.append(this.name);
        signatureBuilder.append('(');
        int lastParameterIndex = this.parameters.length - 1;
        for (int i = 0; i < this.parameters.length; ++i) {
            signatureBuilder.append(this.parameters[i].toString(debug));
            if (i == lastParameterIndex) continue;
            signatureBuilder.append(", ");
        }
        signatureBuilder.append(')');
        if (includeReturnType && this.returnType != null) {
            signatureBuilder.append(" :: ");
            signatureBuilder.append(Utils.toEnglishPlural(this.returnType.getCodeName(), !this.single));
        }
        return signatureBuilder.toString();
    }
}

