/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.effects.Delay;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDismountEvent;
import org.bukkit.event.entity.EntityEvent;
import org.bukkit.event.entity.EntityMountEvent;
import org.bukkit.event.vehicle.VehicleEnterEvent;
import org.bukkit.event.vehicle.VehicleExitEvent;
import org.jetbrains.annotations.Nullable;

@Name(value="Vehicle")
@Description(value={"The vehicle an entity is in, if any. This can actually be any entity, e.g. spider jockeys are skeletons that ride on a spider, so the spider is the 'vehicle' of the skeleton.", "See also: <a href='#ExprPassenger'>passenger</a>"})
@Examples(value={"vehicle of the player is a minecart"})
@Since(value={"2.0"})
public class ExprVehicle
extends SimplePropertyExpression<Entity, Entity> {
    private static final boolean HAS_NEW_MOUNT_EVENTS = Skript.classExists("org.bukkit.event.entity.EntityMountEvent");
    private static final boolean HAS_OLD_MOUNT_EVENTS;
    @Nullable
    private static final Class<?> OLD_MOUNT_EVENT_CLASS;
    @Nullable
    private static final MethodHandle OLD_GETMOUNT_HANDLE;
    @Nullable
    private static final Class<?> OLD_DISMOUNT_EVENT_CLASS;
    @Nullable
    private static final MethodHandle OLD_GETDISMOUNTED_HANDLE;

    protected Entity[] get(Event e, Entity[] source) {
        return this.get(source, entity -> {
            if (this.getTime() >= 0 && e instanceof VehicleEnterEvent && entity.equals((Object)((VehicleEnterEvent)e).getEntered()) && !Delay.isDelayed(e)) {
                return ((VehicleEnterEvent)e).getVehicle();
            }
            if (this.getTime() >= 0 && e instanceof VehicleExitEvent && entity.equals((Object)((VehicleExitEvent)e).getExited()) && !Delay.isDelayed(e)) {
                return ((VehicleExitEvent)e).getVehicle();
            }
            if ((HAS_OLD_MOUNT_EVENTS || HAS_NEW_MOUNT_EVENTS) && this.getTime() >= 0 && !Delay.isDelayed(e) && e instanceof EntityEvent && entity.equals((Object)((EntityEvent)e).getEntity())) {
                if (HAS_NEW_MOUNT_EVENTS) {
                    if (e instanceof EntityMountEvent) {
                        return ((EntityMountEvent)e).getMount();
                    }
                    if (e instanceof EntityDismountEvent) {
                        return ((EntityDismountEvent)e).getDismounted();
                    }
                } else {
                    try {
                        assert (OLD_MOUNT_EVENT_CLASS != null);
                        if (OLD_MOUNT_EVENT_CLASS.isInstance(e)) {
                            assert (OLD_GETMOUNT_HANDLE != null);
                            return OLD_GETMOUNT_HANDLE.invoke(e);
                        }
                        assert (OLD_DISMOUNT_EVENT_CLASS != null);
                        if (OLD_DISMOUNT_EVENT_CLASS.isInstance(e)) {
                            assert (OLD_GETDISMOUNTED_HANDLE != null);
                            return OLD_GETDISMOUNTED_HANDLE.invoke(e);
                        }
                    }
                    catch (Throwable ex) {
                        Skript.exception(ex, "An error occurred while trying to invoke legacy mount event support.");
                    }
                }
            }
            return entity.getVehicle();
        });
    }

    @Override
    @Nullable
    public Entity convert(Entity e) {
        assert (false);
        return e.getVehicle();
    }

    @Override
    public Class<? extends Entity> getReturnType() {
        return Entity.class;
    }

    @Override
    protected String getPropertyName() {
        return "vehicle";
    }

    @Override
    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return new Class[]{Entity.class, EntityData.class};
        }
        return super.acceptChange(mode);
    }

    @Override
    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            assert (delta != null);
            Entity[] ps = (Entity[])this.getExpr().getArray(e);
            if (ps.length == 0) {
                return;
            }
            Object o = delta[0];
            if (o instanceof Entity) {
                ((Entity)o).eject();
                Entity p = CollectionUtils.getRandom(ps);
                assert (p != null);
                p.leaveVehicle();
                ((Entity)o).setPassenger(p);
            } else if (o instanceof EntityData) {
                for (Entity p : ps) {
                    Object v = ((EntityData)o).spawn(p.getLocation());
                    if (v == null) continue;
                    v.setPassenger(p);
                }
            } else assert (false);
        } else {
            super.change(e, delta, mode);
        }
    }

    @Override
    public boolean setTime(int time) {
        return super.setTime(time, this.getExpr(), VehicleEnterEvent.class, VehicleExitEvent.class);
    }

    static {
        ExprVehicle.register(ExprVehicle.class, Entity.class, "vehicle[s]", "entities");
        boolean hasOldMountEvents = !HAS_NEW_MOUNT_EVENTS && Skript.classExists("org.spigotmc.event.entity.EntityMountEvent");
        Class<?> oldMountEventClass = null;
        MethodHandle oldGetMountHandle = null;
        Class<?> oldDismountEventClass = null;
        MethodHandle oldGetDismountedHandle = null;
        if (hasOldMountEvents) {
            try {
                MethodHandles.Lookup lookup = MethodHandles.lookup();
                MethodType entityReturnType = MethodType.methodType(Entity.class);
                oldMountEventClass = Class.forName("org.spigotmc.event.entity.EntityMountEvent");
                oldGetMountHandle = lookup.findVirtual(oldMountEventClass, "getMount", entityReturnType);
                oldDismountEventClass = Class.forName("org.spigotmc.event.entity.EntityDismountEvent");
                oldGetDismountedHandle = lookup.findVirtual(oldDismountEventClass, "getDismounted", entityReturnType);
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException e) {
                hasOldMountEvents = false;
                oldMountEventClass = null;
                oldGetMountHandle = null;
                oldDismountEventClass = null;
                oldGetDismountedHandle = null;
                Skript.exception((Throwable)e, "Failed to load old mount event support.");
            }
        }
        HAS_OLD_MOUNT_EVENTS = hasOldMountEvents;
        OLD_MOUNT_EVENT_CLASS = oldMountEventClass;
        OLD_GETMOUNT_HANDLE = oldGetMountHandle;
        OLD_DISMOUNT_EVENT_CLASS = oldDismountEventClass;
        OLD_GETDISMOUNTED_HANDLE = oldGetDismountedHandle;
    }
}

