/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.util.LiteralUtils;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Shuffled List")
@Description(value={"Shuffles given list randomly. This is done by replacing indices by random numbers in resulting list."})
@Examples(value={"set {_list::*} to shuffled {_list::*}"})
@Since(value={"2.2-dev32"})
public class ExprShuffledList
extends SimpleExpression<Object> {
    private Expression<?> list;

    public ExprShuffledList() {
    }

    public ExprShuffledList(Expression<?> list) {
        this.list = list;
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.list = LiteralUtils.defendExpression(exprs[0]);
        return LiteralUtils.canInitSafely(this.list);
    }

    @Override
    @Nullable
    protected Object[] get(Event e) {
        Object[] origin = (Object[])this.list.getArray(e).clone();
        List<Object> shuffled = Arrays.asList(origin);
        Collections.shuffle(shuffled);
        Object[] array = (Object[])Array.newInstance(this.getReturnType(), origin.length);
        return shuffled.toArray(array);
    }

    @Override
    @Nullable
    public <R> Expression<? extends R> getConvertedExpression(Class<R> ... to) {
        if (CollectionUtils.containsSuperclass(to, this.getReturnType())) {
            return this;
        }
        Expression<R> convertedList = this.list.getConvertedExpression(to);
        if (convertedList != null) {
            return new ExprShuffledList(convertedList);
        }
        return null;
    }

    @Override
    public Class<?> getReturnType() {
        return this.list.getReturnType();
    }

    @Override
    public Class<?>[] possibleReturnTypes() {
        return this.list.possibleReturnTypes();
    }

    @Override
    public boolean canReturn(Class<?> returnType) {
        return this.list.canReturn(returnType);
    }

    @Override
    public boolean isSingle() {
        return false;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return "shuffled " + this.list.toString(e, debug);
    }

    static {
        Skript.registerExpression(ExprShuffledList.class, Object.class, ExpressionType.COMBINED, "shuffled %objects%");
    }
}

