/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.simplification.SimplifiedLiteral;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.registrations.Feature;
import ch.njol.skript.util.LiteralUtils;
import ch.njol.skript.util.Patterns;
import ch.njol.util.Kleenean;
import ch.njol.util.StringUtils;
import ch.njol.util.coll.CollectionUtils;
import com.google.common.collect.Iterators;
import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.lang.ArrayUtils;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;
import org.skriptlang.skript.lang.util.SkriptQueue;

@Name(value="Elements")
@Description(value={"The first, last, range or a random element of a set, e.g. a list variable, or a queue.", "Asking for elements from a queue will also remove them from the queue, see the new queue expression for more information.", "See also: <a href='#ExprRandom'>random expression</a>"})
@Examples(value={"broadcast the first 3 elements of {top players::*}", "set {_last} to last element of {top players::*}", "set {_random player} to random element out of all players", "send 2nd last element of {top players::*} to player", "set {page2::*} to elements from 11 to 20 of {top players::*}", "broadcast the 1st element in {queue}", "broadcast the first 3 elements in {queue}"})
@Since(value={"2.0, 2.7 (relative to last element), 2.8.0 (range of elements)"})
public class ExprElement<T>
extends SimpleExpression<T> {
    private static final Patterns<ElementType[]> PATTERNS = new Patterns(new Object[][]{{"[the] (first|1:last) element [out] of %objects%", new ElementType[]{ElementType.FIRST_ELEMENT, ElementType.LAST_ELEMENT}}, {"[the] (first|1:last) %integer% elements [out] of %objects%", new ElementType[]{ElementType.FIRST_X_ELEMENTS, ElementType.LAST_X_ELEMENTS}}, {"[a] random element [out] of %objects%", new ElementType[]{ElementType.RANDOM}}, {"[the] %integer%(st|nd|rd|th) [1:[to] last] element [out] of %objects%", new ElementType[]{ElementType.ORDINAL, ElementType.TAIL_END_ORDINAL}}, {"[the] elements (from|between) %integer% (to|and) %integer% [out] of %objects%", new ElementType[]{ElementType.RANGE}}, {"[the] (first|next|1:last) element (of|in) %queue%", new ElementType[]{ElementType.FIRST_ELEMENT, ElementType.LAST_ELEMENT}}, {"[the] (first|1:last) %integer% elements (of|in) %queue%", new ElementType[]{ElementType.FIRST_X_ELEMENTS, ElementType.LAST_X_ELEMENTS}}, {"[a] random element (of|in) %queue%", new ElementType[]{ElementType.RANDOM}}, {"[the] %integer%(st|nd|rd|th) [1:[to] last] element (of|in) %queue%", new ElementType[]{ElementType.ORDINAL, ElementType.TAIL_END_ORDINAL}}, {"[the] elements (from|between) %integer% (to|and) %integer% (of|in) %queue%", new ElementType[]{ElementType.RANGE}}});
    private Expression<? extends T> expr;
    @Nullable
    private Expression<Integer> startIndex;
    @Nullable
    private Expression<Integer> endIndex;
    private ElementType type;
    private boolean queue;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        ElementType[] types = PATTERNS.getInfo(matchedPattern);
        boolean bl = this.queue = matchedPattern > 4;
        if (this.queue && !this.getParser().hasExperiment(Feature.QUEUES)) {
            return false;
        }
        this.expr = this.queue ? exprs[exprs.length - 1] : LiteralUtils.defendExpression(exprs[exprs.length - 1]);
        this.type = types[parseResult.mark];
        switch (this.type.ordinal()) {
            case 7: {
                this.endIndex = exprs[1];
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                this.startIndex = exprs[0];
                break;
            }
            default: {
                this.startIndex = null;
            }
        }
        return this.queue || LiteralUtils.canInitSafely(this.expr);
    }

    @Override
    protected T @Nullable [] get(Event event) {
        Object[] elementArray;
        Integer integer;
        if (this.queue) {
            return this.getFromQueue(event);
        }
        Iterator iterator = this.expr.iterator(event);
        if (iterator == null || !iterator.hasNext()) {
            return null;
        }
        Object element = null;
        Class<T> returnType = this.getReturnType();
        int startIndex = 0;
        int endIndex = 0;
        if (this.startIndex != null) {
            integer = this.startIndex.getSingle(event);
            if (integer == null) {
                return null;
            }
            startIndex = integer;
            if (startIndex <= 0 && this.type != ElementType.RANGE) {
                return null;
            }
        }
        if (this.endIndex != null) {
            integer = this.endIndex.getSingle(event);
            if (integer == null) {
                return null;
            }
            endIndex = integer;
        }
        switch (this.type.ordinal()) {
            case 0: {
                element = iterator.next();
                break;
            }
            case 1: {
                element = Iterators.getLast(iterator);
                break;
            }
            case 4: {
                element = CollectionUtils.getRandom(Iterators.toArray(iterator, returnType));
                break;
            }
            case 5: {
                Iterators.advance(iterator, (int)(startIndex - 1));
                if (!iterator.hasNext()) {
                    return null;
                }
                element = iterator.next();
                break;
            }
            case 6: {
                elementArray = Iterators.toArray(iterator, returnType);
                if (startIndex > elementArray.length) {
                    return null;
                }
                element = elementArray[elementArray.length - startIndex];
                break;
            }
            case 2: {
                return Iterators.toArray((Iterator)Iterators.limit(iterator, (int)startIndex), returnType);
            }
            case 3: {
                elementArray = Iterators.toArray(iterator, returnType);
                startIndex = Math.min(startIndex, elementArray.length);
                return CollectionUtils.subarray(elementArray, elementArray.length - startIndex, elementArray.length);
            }
            case 7: {
                elementArray = Iterators.toArray(iterator, returnType);
                boolean reverse = startIndex > endIndex;
                int from = Math.min(startIndex, endIndex) - 1;
                int to = Math.max(startIndex, endIndex);
                Object[] elements = CollectionUtils.subarray(elementArray, from, to);
                if (reverse) {
                    ArrayUtils.reverse((Object[])elements);
                }
                return elements;
            }
        }
        elementArray = (Object[])Array.newInstance(this.getReturnType(), 1);
        elementArray[0] = element;
        return elementArray;
    }

    private T @Nullable [] getFromQueue(Event event) {
        SkriptQueue queue = (SkriptQueue)this.expr.getSingle(event);
        if (queue == null) {
            return null;
        }
        Integer startIndex = 0;
        Integer endIndex = 0;
        if (this.startIndex != null && ((startIndex = this.startIndex.getSingle(event)) == null || startIndex <= 0 && this.type != ElementType.RANGE)) {
            return null;
        }
        if (this.endIndex != null && (endIndex = this.endIndex.getSingle(event)) == null) {
            return null;
        }
        return switch (this.type.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> CollectionUtils.array(queue.pollFirst());
            case 1 -> CollectionUtils.array(queue.pollLast());
            case 4 -> CollectionUtils.array(queue.removeSafely(ThreadLocalRandom.current().nextInt(0, queue.size())));
            case 5 -> CollectionUtils.array(queue.removeSafely(startIndex - 1));
            case 6 -> CollectionUtils.array(queue.removeSafely(queue.size() - startIndex));
            case 2 -> CollectionUtils.array(queue.removeRangeSafely(0, startIndex));
            case 3 -> CollectionUtils.array(queue.removeRangeSafely(queue.size() - startIndex, queue.size()));
            case 7 -> {
                boolean reverse = startIndex > endIndex;
                Object[] elements = CollectionUtils.array(queue.removeRangeSafely(Math.min(startIndex, endIndex) - 1, Math.max(startIndex, endIndex)));
                if (reverse) {
                    ArrayUtils.reverse((Object[])elements);
                }
                yield elements;
            }
        };
    }

    @Override
    @Nullable
    public <R> Expression<? extends R> getConvertedExpression(Class<R> ... to) {
        Expression<R> convExpr = this.expr.getConvertedExpression(to);
        if (convExpr == null) {
            return null;
        }
        ExprElement<T> exprElement = new ExprElement<T>();
        exprElement.expr = convExpr;
        exprElement.startIndex = this.startIndex;
        exprElement.endIndex = this.endIndex;
        exprElement.type = this.type;
        exprElement.queue = this.queue;
        return exprElement;
    }

    @Override
    public boolean isSingle() {
        return this.type != ElementType.FIRST_X_ELEMENTS && this.type != ElementType.LAST_X_ELEMENTS && this.type != ElementType.RANGE;
    }

    @Override
    public Class<? extends T> getReturnType() {
        if (this.queue) {
            return Object.class;
        }
        return this.expr.getReturnType();
    }

    @Override
    public Class<? extends T>[] possibleReturnTypes() {
        if (!this.queue) {
            return this.expr.possibleReturnTypes();
        }
        return super.possibleReturnTypes();
    }

    @Override
    public boolean canReturn(Class<?> returnType) {
        if (!this.queue) {
            return this.expr.canReturn(returnType);
        }
        return super.canReturn(returnType);
    }

    @Override
    public Expression<? extends T> simplify() {
        if (!this.queue && this.expr instanceof Literal && this.type != ElementType.RANDOM && (this.startIndex == null || this.startIndex instanceof Literal) && (this.endIndex == null || this.endIndex instanceof Literal)) {
            return SimplifiedLiteral.fromExpression(this);
        }
        return this;
    }

    @Override
    public String toString(@Nullable Event event, boolean debug) {
        Object prefix;
        switch (this.type.ordinal()) {
            case 0: {
                prefix = "the first";
                break;
            }
            case 1: {
                prefix = "the last";
                break;
            }
            case 2: {
                assert (this.startIndex != null);
                prefix = "the first " + this.startIndex.toString(event, debug);
                break;
            }
            case 3: {
                assert (this.startIndex != null);
                prefix = "the last " + this.startIndex.toString(event, debug);
                break;
            }
            case 4: {
                prefix = "a random";
                break;
            }
            case 5: 
            case 6: {
                Integer integer;
                assert (this.startIndex != null);
                prefix = "the ";
                prefix = this.startIndex instanceof Literal ? ((integer = (Integer)((Literal)this.startIndex).getSingle()) == null ? (String)prefix + this.startIndex.toString(event, debug) + "th" : (String)prefix + StringUtils.fancyOrderNumber(integer)) : (String)prefix + this.startIndex.toString(event, debug) + "th";
                if (this.type != ElementType.TAIL_END_ORDINAL) break;
                prefix = (String)prefix + " last";
                break;
            }
            case 7: {
                assert (this.startIndex != null && this.endIndex != null);
                return "the elements from " + this.startIndex.toString(event, debug) + " to " + this.endIndex.toString(event, debug) + " of " + this.expr.toString(event, debug);
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return (String)prefix + (this.isSingle() ? " element" : " elements") + " of " + this.expr.toString(event, debug);
    }

    static {
        Skript.registerExpression(ExprElement.class, Object.class, ExpressionType.PROPERTY, PATTERNS.getPatterns());
    }

    private static enum ElementType {
        FIRST_ELEMENT,
        LAST_ELEMENT,
        FIRST_X_ELEMENTS,
        LAST_X_ELEMENTS,
        RANDOM,
        ORDINAL,
        TAIL_END_ORDINAL,
        RANGE;

    }
}

