/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import org.bukkit.event.Event;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.Nullable;

@Name(value="Book Title")
@Description(value={"The title of a book."})
@Examples(value={"on book sign:", "\tmessage \"Book Title: %title of event-item%\""})
@Since(value={"2.2-dev31"})
public class ExprBookTitle
extends SimplePropertyExpression<ItemType, String> {
    @Override
    @Nullable
    public String convert(ItemType item) {
        ItemMeta meta = item.getItemMeta();
        if (meta instanceof BookMeta) {
            return ((BookMeta)meta).getTitle();
        }
        return null;
    }

    @Override
    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.RESET || mode == Changer.ChangeMode.DELETE) {
            return new Class[]{String.class};
        }
        return null;
    }

    @Override
    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        String title = delta == null ? null : (String)delta[0];
        for (ItemType item : (ItemType[])this.getExpr().getArray(e)) {
            ItemMeta meta = item.getItemMeta();
            if (!(meta instanceof BookMeta)) continue;
            ((BookMeta)meta).setTitle(title);
            item.setItemMeta(meta);
        }
    }

    @Override
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    @Override
    protected String getPropertyName() {
        return "book title";
    }

    static {
        ExprBookTitle.register(ExprBookTitle.class, String.class, "book (name|title)", "itemtypes");
    }
}

