/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.event.Event;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.Nullable;

@Name(value="Book Author")
@Description(value={"The author of a book."})
@Examples(value={"on book sign:", "\tmessage \"Book Title: %author of event-item%\""})
@Since(value={"2.2-dev31"})
public class ExprBookAuthor
extends SimplePropertyExpression<ItemType, String> {
    @Override
    @Nullable
    public String convert(ItemType item) {
        String string;
        ItemMeta itemMeta = item.getItemMeta();
        if (itemMeta instanceof BookMeta) {
            BookMeta bookMeta = (BookMeta)itemMeta;
            string = bookMeta.getAuthor();
        } else {
            string = null;
        }
        return string;
    }

    @Override
    public Class<?> @Nullable [] acceptChange(Changer.ChangeMode mode) {
        return switch (mode) {
            case Changer.ChangeMode.SET, Changer.ChangeMode.RESET, Changer.ChangeMode.DELETE -> CollectionUtils.array(String.class);
            default -> null;
        };
    }

    @Override
    public void change(Event event, Object @Nullable [] delta, Changer.ChangeMode mode) {
        String author = delta == null ? null : (String)delta[0];
        for (ItemType item : (ItemType[])this.getExpr().getArray(event)) {
            ItemMeta itemMeta = item.getItemMeta();
            if (!(itemMeta instanceof BookMeta)) continue;
            BookMeta bookMeta = (BookMeta)itemMeta;
            bookMeta.setAuthor(author);
            item.setItemMeta((ItemMeta)bookMeta);
        }
    }

    @Override
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    @Override
    protected String getPropertyName() {
        return "book author";
    }

    static {
        ExprBookAuthor.register(ExprBookAuthor.class, String.class, "[book] (author|writer|publisher)", "itemtypes");
    }
}

