/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.events;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import javax.annotation.Nullable;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.potion.PotionEffectType;

public class EvtEntityPotion
extends SkriptEvent {
    private Expression<PotionEffectType> potionEffects;
    private Expression<EntityPotionEffectEvent.Cause> cause;

    @Override
    public boolean init(Literal<?>[] args, int matchedPattern, SkriptParser.ParseResult parseResult) {
        this.potionEffects = args[0];
        this.cause = args[1];
        return true;
    }

    @Override
    public boolean check(Event event) {
        EntityPotionEffectEvent potionEvent = (EntityPotionEffectEvent)event;
        boolean effectMatches = this.potionEffects == null || potionEvent.getOldEffect() != null && this.potionEffects.check(event, effectType -> effectType.equals(potionEvent.getOldEffect().getType())) || potionEvent.getNewEffect() != null && this.potionEffects.check(event, effectType -> effectType.equals(potionEvent.getNewEffect().getType()));
        boolean causeMatches = this.cause == null || this.cause.check(event, cause -> cause.equals((Object)potionEvent.getCause()));
        return effectMatches && causeMatches;
    }

    @Override
    public String toString(@Nullable Event event, boolean debug) {
        return "on entity potion effect modification";
    }

    static {
        Skript.registerEvent("Entity Potion Effect", EvtEntityPotion.class, EntityPotionEffectEvent.class, "entity potion effect [modif[y|ication]] [[of] %-potioneffecttypes%] [due to %-entitypotioncause%]").description("Called when an entity's potion effect is modified.", "This modification can include adding, removing or changing their potion effect.").examples("on entity potion effect modification:", "\t\tbroadcast \"A potion effect was added to %event-entity%!\" ", "", "on entity potion effect modification of night vision:").since("2.10");
    }
}

