/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.entity;

import ch.njol.skript.SkriptAPIException;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.coll.CollectionUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.bukkit.entity.Villager;
import org.bukkit.entity.ZombieVillager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ZombieVillagerData
extends EntityData<ZombieVillager> {
    private static final List<Villager.Profession> professions;
    @Nullable
    private Villager.Profession profession = null;

    public ZombieVillagerData() {
    }

    public ZombieVillagerData(@Nullable Villager.Profession profession) {
        this.profession = profession;
        this.matchedPattern = profession != null ? professions.indexOf(profession) + 1 : 0;
    }

    @Override
    protected boolean init(Literal<?>[] exprs, int matchedPattern, SkriptParser.ParseResult parseResult) {
        if (matchedPattern > 0) {
            this.profession = professions.get(matchedPattern - 1);
        }
        return true;
    }

    @Override
    protected boolean init(@Nullable Class<? extends ZombieVillager> zombieClass, @Nullable ZombieVillager zombieVillager) {
        this.profession = zombieVillager == null ? null : zombieVillager.getVillagerProfession();
        return true;
    }

    @Override
    protected boolean deserialize(String s) {
        try {
            this.profession = professions.get(Integer.parseInt(s));
        }
        catch (IndexOutOfBoundsException | NumberFormatException e) {
            throw new SkriptAPIException("Cannot parse zombie villager type " + s);
        }
        return true;
    }

    @Override
    public void set(ZombieVillager zombieVillager) {
        Villager.Profession prof;
        Villager.Profession profession = prof = this.profession == null ? CollectionUtils.getRandom(professions) : this.profession;
        assert (prof != null);
        zombieVillager.setVillagerProfession(prof);
    }

    @Override
    protected boolean match(ZombieVillager zombieVillager) {
        return this.profession == null || this.profession == zombieVillager.getVillagerProfession();
    }

    @Override
    public Class<? extends ZombieVillager> getType() {
        return ZombieVillager.class;
    }

    @Override
    protected boolean equals_i(EntityData<?> obj) {
        if (!(obj instanceof ZombieVillagerData)) {
            return false;
        }
        ZombieVillagerData zombieVillagerData = (ZombieVillagerData)obj;
        return this.profession == null || this.profession.equals((Object)zombieVillagerData.profession);
    }

    @Override
    protected int hashCode_i() {
        return Objects.hashCode(this.profession);
    }

    @Override
    public boolean isSupertypeOf(EntityData<?> entityData) {
        if (entityData instanceof ZombieVillagerData) {
            ZombieVillagerData zombieVillagerData = (ZombieVillagerData)entityData;
            return this.profession == null || this.profession.equals((Object)zombieVillagerData.profession);
        }
        return false;
    }

    @Override
    @NotNull
    public EntityData getSuperType() {
        return new ZombieVillagerData(this.profession);
    }

    static {
        EntityData.register(ZombieVillagerData.class, "zombie villager", ZombieVillager.class, 0, "zombie villager", "zombie normal", "zombie armorer", "zombie butcher", "zombie cartographer", "zombie cleric", "zombie farmer", "zombie fisherman", "zombie fletcher", "zombie leatherworker", "zombie librarian", "zombie mason", "zombie nitwit", "zombie shepherd", "zombie toolsmith", "zombie weaponsmith");
        professions = Arrays.asList(Villager.Profession.NONE, Villager.Profession.ARMORER, Villager.Profession.BUTCHER, Villager.Profession.CARTOGRAPHER, Villager.Profession.CLERIC, Villager.Profession.FARMER, Villager.Profession.FISHERMAN, Villager.Profession.FLETCHER, Villager.Profession.LEATHERWORKER, Villager.Profession.LIBRARIAN, Villager.Profession.MASON, Villager.Profession.NITWIT, Villager.Profession.SHEPHERD, Villager.Profession.TOOLSMITH, Villager.Profession.WEAPONSMITH);
    }
}

