/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.entity;

import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.localization.ArgsMessage;
import java.util.function.Consumer;
import org.bukkit.Location;
import org.bukkit.entity.ExperienceOrb;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XpOrbData
extends EntityData<ExperienceOrb> {
    private int xp = -1;
    private static final ArgsMessage format;

    public XpOrbData() {
    }

    public XpOrbData(int xp) {
        this.xp = xp;
    }

    @Override
    protected boolean init(Literal<?>[] exprs, int matchedPattern, SkriptParser.ParseResult parseResult) {
        return true;
    }

    @Override
    protected boolean init(@Nullable Class<? extends ExperienceOrb> c, @Nullable ExperienceOrb e) {
        this.xp = e == null ? -1 : e.getExperience();
        return true;
    }

    @Override
    public Class<? extends ExperienceOrb> getType() {
        return ExperienceOrb.class;
    }

    @Override
    protected boolean match(ExperienceOrb entity) {
        return this.xp == -1 || entity.getExperience() == this.xp;
    }

    @Override
    public void set(ExperienceOrb entity) {
        if (this.xp != -1) {
            entity.setExperience(this.xp + entity.getExperience());
        }
    }

    @Override
    @Nullable
    public ExperienceOrb spawn(Location loc, @Nullable Consumer<ExperienceOrb> consumer) {
        ExperienceOrb orb = super.spawn(loc, consumer);
        if (orb == null) {
            return null;
        }
        if (this.xp == -1) {
            orb.setExperience(1 + orb.getExperience());
        }
        return orb;
    }

    @Override
    public String toString(int flags) {
        return this.xp == -1 ? super.toString(flags) : format.toString(super.toString(flags), this.xp);
    }

    public int getExperience() {
        return this.xp == -1 ? 1 : this.xp;
    }

    public int getInternalExperience() {
        return this.xp;
    }

    @Override
    protected int hashCode_i() {
        return this.xp;
    }

    @Override
    protected boolean equals_i(EntityData<?> obj) {
        if (!(obj instanceof XpOrbData)) {
            return false;
        }
        XpOrbData other = (XpOrbData)obj;
        return this.xp == other.xp;
    }

    @Override
    protected boolean deserialize(String s) {
        try {
            this.xp = Integer.parseInt(s);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Override
    public boolean isSupertypeOf(EntityData<?> e) {
        if (e instanceof XpOrbData) {
            return this.xp == -1 || ((XpOrbData)e).xp == this.xp;
        }
        return false;
    }

    @Override
    @NotNull
    public EntityData getSuperType() {
        return new XpOrbData();
    }

    static {
        EntityData.register(XpOrbData.class, "xporb", ExperienceOrb.class, "xp-orb");
        format = new ArgsMessage("entities.xp-orb.format");
    }
}

