/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.entity;

import ch.njol.skript.Skript;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.Color;
import ch.njol.util.coll.CollectionUtils;
import com.google.common.collect.Iterators;
import java.util.Objects;
import org.bukkit.DyeColor;
import org.bukkit.entity.Wolf;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WolfData
extends EntityData<Wolf> {
    private static boolean variantsEnabled = false;
    private static Object[] variants;
    @Nullable
    private Object variant;
    @Nullable
    private DyeColor collarColor;
    private int angry = 0;
    private int tamed = 0;

    @Override
    protected boolean init(Literal<?>[] exprs, int matchedPattern, SkriptParser.ParseResult parseResult) {
        if (matchedPattern <= 2) {
            this.angry = matchedPattern - 1;
        } else {
            int n = this.tamed = matchedPattern == 3 ? -1 : 1;
        }
        if (exprs[0] != null && variantsEnabled) {
            this.variant = exprs[0].getSingle();
        }
        if (exprs[1] != null) {
            this.collarColor = ((Color)exprs[1].getSingle()).asDyeColor();
        }
        return true;
    }

    @Override
    protected boolean init(@Nullable Class<? extends Wolf> c, @Nullable Wolf wolf) {
        if (wolf != null) {
            this.angry = wolf.isAngry() ? 1 : -1;
            this.tamed = wolf.isTamed() ? 1 : -1;
            this.collarColor = wolf.getCollarColor();
            if (variantsEnabled) {
                this.variant = wolf.getVariant();
            }
        }
        return true;
    }

    @Override
    public void set(Wolf entity) {
        if (this.angry != 0) {
            entity.setAngry(this.angry == 1);
        }
        if (this.tamed != 0) {
            entity.setTamed(this.tamed == 1);
        }
        if (this.collarColor != null) {
            entity.setCollarColor(this.collarColor);
        }
        Object variantSet = null;
        if (variantsEnabled) {
            variantSet = this.variant != null ? this.variant : CollectionUtils.getRandom(variants);
            entity.setVariant((Wolf.Variant)variantSet);
        }
    }

    @Override
    public boolean match(Wolf entity) {
        return !(this.angry != 0 && entity.isAngry() != (this.angry == 1) || this.tamed != 0 && entity.isTamed() != (this.tamed == 1) || this.collarColor != null && entity.getCollarColor() != this.collarColor || this.variant != null && entity.getVariant() != this.variant);
    }

    @Override
    public Class<Wolf> getType() {
        return Wolf.class;
    }

    @Override
    protected int hashCode_i() {
        int prime = 31;
        int result = 1;
        result = prime * result + this.angry;
        result = prime * result + this.tamed;
        result = prime * result + (this.collarColor == null ? 0 : this.collarColor.hashCode());
        if (variantsEnabled) {
            result = prime * result + (this.variant == null ? 0 : Objects.hashCode(this.variant));
        }
        return result;
    }

    @Override
    protected boolean equals_i(EntityData<?> obj) {
        if (!(obj instanceof WolfData)) {
            return false;
        }
        WolfData other = (WolfData)obj;
        if (this.angry != other.angry) {
            return false;
        }
        if (this.tamed != other.tamed) {
            return false;
        }
        if (this.collarColor != other.collarColor) {
            return false;
        }
        return !variantsEnabled || this.variant == other.variant;
    }

    @Override
    @Deprecated(since="2.3.0", forRemoval=true)
    protected boolean deserialize(String s) {
        String[] split = s.split("\\|");
        if (split.length != 2) {
            return false;
        }
        try {
            this.angry = Integer.parseInt(split[0]);
            this.tamed = Integer.parseInt(split[1]);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Override
    public boolean isSupertypeOf(EntityData<?> entityData) {
        if (entityData instanceof WolfData) {
            WolfData wolfData = (WolfData)entityData;
            return !(this.angry != 0 && wolfData.angry != this.angry || this.tamed != 0 && wolfData.tamed != this.tamed || wolfData.collarColor != this.collarColor || variantsEnabled && wolfData.variant != this.variant);
        }
        return false;
    }

    @Override
    @NotNull
    public EntityData<Wolf> getSuperType() {
        return new WolfData();
    }

    static {
        EntityData.register(WolfData.class, "wolf", Wolf.class, 1, "peaceful wolf", "wolf", "angry wolf", "wild wolf", "tamed wolf");
        if (Skript.classExists("org.bukkit.entity.Wolf$Variant")) {
            variantsEnabled = true;
            variants = Iterators.toArray(Classes.getExactClassInfo(Wolf.Variant.class).getSupplier().get(), Wolf.Variant.class);
        }
    }

    public static class WolfVariantDummy {
    }
}

