/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.entity;

import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.variables.Variables;
import ch.njol.util.coll.CollectionUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.bukkit.entity.Villager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VillagerData
extends EntityData<Villager> {
    private static final List<Villager.Profession> professions;
    @Nullable
    private Villager.Profession profession = null;

    public VillagerData() {
    }

    public VillagerData(@Nullable Villager.Profession profession) {
        this.profession = profession;
        this.matchedPattern = profession != null ? professions.indexOf(profession) + 1 : 0;
    }

    @Override
    protected boolean init(Literal<?>[] exprs, int matchedPattern, SkriptParser.ParseResult parseResult) {
        if (matchedPattern > 0) {
            this.profession = professions.get(matchedPattern - 1);
        }
        return true;
    }

    @Override
    protected boolean init(@Nullable Class<? extends Villager> villagerClass, @Nullable Villager villager) {
        this.profession = villager == null ? null : villager.getProfession();
        return true;
    }

    @Override
    public void set(Villager villager) {
        Villager.Profession prof;
        Villager.Profession profession = prof = this.profession == null ? CollectionUtils.getRandom(professions) : this.profession;
        assert (prof != null);
        villager.setProfession(prof);
        if (this.profession == Villager.Profession.NITWIT) {
            villager.setRecipes(Collections.emptyList());
        }
    }

    @Override
    protected boolean match(Villager villager) {
        return this.profession == null || villager.getProfession() == this.profession;
    }

    @Override
    public Class<? extends Villager> getType() {
        return Villager.class;
    }

    @Override
    protected int hashCode_i() {
        return Objects.hashCode(this.profession);
    }

    @Override
    protected boolean equals_i(EntityData<?> obj) {
        if (!(obj instanceof VillagerData)) {
            return false;
        }
        VillagerData villagerData = (VillagerData)obj;
        return this.profession == villagerData.profession;
    }

    @Override
    protected boolean deserialize(String s) {
        if (s.isEmpty()) {
            return true;
        }
        try {
            this.profession = Enum.valueOf(Villager.Profession.class, s);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    @Override
    public boolean isSupertypeOf(EntityData<?> entityData) {
        if (entityData instanceof VillagerData) {
            VillagerData villagerData = (VillagerData)entityData;
            return this.profession == null || this.profession.equals((Object)villagerData.profession);
        }
        return false;
    }

    @Override
    @NotNull
    public EntityData getSuperType() {
        return new VillagerData(this.profession);
    }

    static {
        Variables.yggdrasil.registerSingleClass(Villager.Profession.class, "Villager.Profession");
        EntityData.register(VillagerData.class, "villager", Villager.class, 0, "villager", "normal", "armorer", "butcher", "cartographer", "cleric", "farmer", "fisherman", "fletcher", "leatherworker", "librarian", "mason", "nitwit", "shepherd", "toolsmith", "weaponsmith");
        professions = Arrays.asList(Villager.Profession.NONE, Villager.Profession.ARMORER, Villager.Profession.BUTCHER, Villager.Profession.CARTOGRAPHER, Villager.Profession.CLERIC, Villager.Profession.FARMER, Villager.Profession.FISHERMAN, Villager.Profession.FLETCHER, Villager.Profession.LEATHERWORKER, Villager.Profession.LIBRARIAN, Villager.Profession.MASON, Villager.Profession.NITWIT, Villager.Profession.SHEPHERD, Villager.Profession.TOOLSMITH, Villager.Profession.WEAPONSMITH);
    }
}

