/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.entity;

import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.util.Color;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.DyeColor;
import org.bukkit.entity.TropicalFish;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TropicalFishData
extends EntityData<TropicalFish> {
    private static final TropicalFish.Pattern[] patterns = TropicalFish.Pattern.values();
    @Nullable
    private DyeColor patternColor;
    @Nullable
    private DyeColor bodyColor;

    public TropicalFishData() {
        this(0);
    }

    public TropicalFishData(TropicalFish.Pattern pattern) {
        this.matchedPattern = pattern.ordinal();
    }

    private TropicalFishData(int pattern) {
        this.matchedPattern = pattern;
    }

    @Override
    protected boolean init(Literal<?>[] exprs, int matchedPattern, SkriptParser.ParseResult parseResult) {
        if (exprs.length == 0) {
            return true;
        }
        if (exprs[2] != null) {
            this.patternColor = this.bodyColor = ((Color)exprs[2].getSingle()).asDyeColor();
        }
        if (exprs[0] != null) {
            this.bodyColor = ((Color)exprs[0].getSingle()).asDyeColor();
        }
        if (exprs[1] != null) {
            this.patternColor = ((Color)exprs[1].getSingle()).asDyeColor();
        }
        return true;
    }

    @Override
    protected boolean init(@Nullable Class<? extends TropicalFish> entityClass, @Nullable TropicalFish tropicalFish) {
        if (tropicalFish != null) {
            this.matchedPattern = tropicalFish.getPattern().ordinal();
            this.bodyColor = tropicalFish.getBodyColor();
            this.patternColor = tropicalFish.getPatternColor();
        }
        return true;
    }

    @Override
    public void set(TropicalFish tropicalFish) {
        if (this.matchedPattern == patterns.length) {
            tropicalFish.setPattern(patterns[ThreadLocalRandom.current().nextInt(patterns.length)]);
        } else {
            tropicalFish.setPattern(patterns[this.matchedPattern]);
        }
        if (this.bodyColor != null) {
            tropicalFish.setBodyColor(this.bodyColor);
        }
        if (this.patternColor != null) {
            tropicalFish.setPatternColor(this.patternColor);
        }
    }

    @Override
    protected boolean match(TropicalFish tropicalFish) {
        boolean sameBody;
        boolean samePattern = this.matchedPattern == patterns.length || this.matchedPattern == tropicalFish.getPattern().ordinal();
        boolean bl = sameBody = this.bodyColor == null || this.bodyColor == tropicalFish.getBodyColor();
        if (this.patternColor == null) {
            return samePattern && sameBody;
        }
        return samePattern && sameBody && this.patternColor == tropicalFish.getPatternColor();
    }

    @Override
    public Class<? extends TropicalFish> getType() {
        return TropicalFish.class;
    }

    @Override
    protected boolean equals_i(EntityData<?> entityData) {
        if (!(entityData instanceof TropicalFishData)) {
            return false;
        }
        TropicalFishData fishData = (TropicalFishData)entityData;
        return this.matchedPattern == fishData.matchedPattern && this.bodyColor == fishData.bodyColor && this.patternColor == fishData.patternColor;
    }

    @Override
    protected int hashCode_i() {
        return Objects.hash(this.matchedPattern, this.bodyColor, this.patternColor);
    }

    @Override
    public boolean isSupertypeOf(EntityData<?> entityData) {
        if (!(entityData instanceof TropicalFishData)) {
            return false;
        }
        TropicalFishData fishData = (TropicalFishData)entityData;
        return this.matchedPattern == fishData.matchedPattern && this.bodyColor == fishData.bodyColor && this.patternColor == fishData.patternColor;
    }

    @Override
    @NotNull
    public EntityData<TropicalFish> getSuperType() {
        return new TropicalFishData(this.matchedPattern);
    }

    static {
        TropicalFishData.register(TropicalFishData.class, "tropical fish", TropicalFish.class, 12, "kob", "sunstreak", "snooper", "dasher", "brinely", "spotty", "flopper", "stripey", "glitter", "blockfish", "betty", "clayfish", "tropical fish");
    }
}

