/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.entity;

import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import java.util.Objects;
import org.bukkit.entity.Strider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StriderData
extends EntityData<Strider> {
    private Kleenean shivering = Kleenean.UNKNOWN;

    public StriderData() {
    }

    public StriderData(Kleenean shivering) {
        this.shivering = shivering;
    }

    @Override
    protected boolean init(Literal<?>[] exprs, int matchedPattern, SkriptParser.ParseResult parseResult) {
        this.shivering = Kleenean.get(matchedPattern - 1);
        return true;
    }

    @Override
    protected boolean init(@Nullable Class<? extends Strider> entityClass, @Nullable Strider entity) {
        this.shivering = Kleenean.get(entity == null ? 0 : (entity.isShivering() ? 1 : -1));
        return true;
    }

    @Override
    public void set(Strider entity) {
        entity.setShivering(this.shivering.isTrue());
    }

    @Override
    protected boolean match(Strider entity) {
        return this.shivering.isUnknown() || this.shivering.isTrue() == entity.isShivering();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isSupertypeOf(EntityData<?> entityData) {
        if (!(entityData instanceof StriderData)) return false;
        StriderData striderData = (StriderData)entityData;
        if (this.shivering.isUnknown()) return true;
        if (!striderData.shivering.is(this.shivering).isTrue()) return false;
        return true;
    }

    @Override
    public Class<? extends Strider> getType() {
        return Strider.class;
    }

    @Override
    @NotNull
    public EntityData<? super Strider> getSuperType() {
        return new StriderData(this.shivering);
    }

    @Override
    protected int hashCode_i() {
        return Objects.hash(new Object[]{this.shivering});
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean equals_i(EntityData<?> entityData) {
        if (!(entityData instanceof StriderData)) return false;
        StriderData striderData = (StriderData)entityData;
        if (striderData.shivering != this.shivering) return false;
        return true;
    }

    @Override
    public String toString(int flags) {
        StringBuilder builder = new StringBuilder();
        switch (this.shivering) {
            case TRUE: {
                builder.append("shivering ");
                break;
            }
            case FALSE: {
                builder.append("warm ");
            }
        }
        return builder.append("strider").toString();
    }

    static {
        StriderData.register(StriderData.class, "strider", Strider.class, 1, "warm strider", "strider", "shivering strider");
    }
}

