/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.entity;

import ch.njol.skript.Skript;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.entity.Parrot;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParrotData
extends EntityData<Parrot> {
    private static Object[] variants;
    private int variant;

    public ParrotData() {
    }

    public ParrotData(int variant) {
        this.variant = variant;
        this.matchedPattern = variant + 1;
    }

    @Override
    protected boolean init(Literal<?>[] exprs, int matchedPattern, SkriptParser.ParseResult parseResult) {
        this.variant = matchedPattern == 0 ? -1 : matchedPattern - 1;
        return true;
    }

    @Override
    protected boolean init(@Nullable Class<? extends Parrot> c, @Nullable Parrot e) {
        if (e != null) {
            Parrot.Variant entityVariant = e.getVariant();
            for (int i = 0; i < variants.length; ++i) {
                Object var = variants[i];
                if (var != entityVariant) continue;
                this.variant = i;
            }
        } else {
            this.variant = -1;
        }
        return true;
    }

    @Override
    public void set(Parrot entity) {
        if (this.variant == -1) {
            int randomVariant = ThreadLocalRandom.current().nextInt(0, variants.length);
            entity.setVariant((Parrot.Variant)variants[randomVariant]);
        } else {
            entity.setVariant((Parrot.Variant)variants[this.variant]);
        }
    }

    @Override
    protected boolean match(Parrot entity) {
        return this.variant == -1 || entity.getVariant() == variants[this.variant];
    }

    @Override
    public Class<? extends Parrot> getType() {
        return Parrot.class;
    }

    @Override
    @NotNull
    public EntityData getSuperType() {
        return new ParrotData(this.variant);
    }

    @Override
    protected int hashCode_i() {
        return this.variant;
    }

    @Override
    protected boolean equals_i(EntityData<?> obj) {
        if (obj instanceof ParrotData) {
            return ((ParrotData)obj).variant == this.variant;
        }
        return false;
    }

    @Override
    public boolean isSupertypeOf(EntityData<?> e) {
        return e instanceof ParrotData && (this.variant == -1 || ((ParrotData)e).variant == this.variant);
    }

    static {
        if (Skript.classExists("org.bukkit.entity.Parrot")) {
            variants = Parrot.Variant.values();
            EntityData.register(ParrotData.class, "parrot", Parrot.class, 0, "parrot", "red parrot", "blue parrot", "green parrot", "cyan parrot", "gray parrot");
        }
    }
}

