/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.entity;

import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.entity.Llama;
import org.bukkit.entity.TraderLlama;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LlamaData
extends EntityData<Llama> {
    private static final Llama.Color[] LLAMA_COLORS = Llama.Color.values();
    @Nullable
    private Llama.Color color = null;
    private boolean isTrader;

    public LlamaData() {
    }

    public LlamaData(@Nullable Llama.Color color, boolean isTrader) {
        this.color = color;
        this.isTrader = isTrader;
        this.matchedPattern = (color != null ? color.ordinal() + 1 : 0) + (isTrader ? 5 : 0);
    }

    @Override
    protected boolean init(Literal<?>[] exprs, int matchedPattern, SkriptParser.ParseResult parseResult) {
        boolean bl = this.isTrader = matchedPattern > 4;
        if (matchedPattern > 5) {
            this.color = LLAMA_COLORS[matchedPattern - 6];
        } else if (matchedPattern > 0 && matchedPattern < 5) {
            this.color = LLAMA_COLORS[matchedPattern - 1];
        }
        this.matchedPattern = (this.color != null ? this.color.ordinal() + 1 : 0) + (this.isTrader ? 5 : 0);
        return true;
    }

    @Override
    protected boolean init(@Nullable Class<? extends Llama> entityClass, @Nullable Llama llama) {
        if (entityClass != null) {
            this.isTrader = TraderLlama.class.isAssignableFrom(entityClass);
        }
        if (llama != null) {
            this.color = llama.getColor();
            this.isTrader = llama instanceof TraderLlama;
        }
        return true;
    }

    @Override
    public void set(Llama entity) {
        Llama.Color randomColor;
        Llama.Color color = randomColor = this.color == null ? CollectionUtils.getRandom(LLAMA_COLORS) : this.color;
        assert (randomColor != null);
        entity.setColor(randomColor);
    }

    @Override
    protected boolean match(Llama entity) {
        if (this.isTrader && !(entity instanceof TraderLlama)) {
            return false;
        }
        return this.color == null || this.color == entity.getColor();
    }

    @Override
    public Class<? extends Llama> getType() {
        return this.isTrader ? TraderLlama.class : Llama.class;
    }

    @Override
    @NotNull
    public EntityData getSuperType() {
        return new LlamaData(this.color, this.isTrader);
    }

    @Override
    protected int hashCode_i() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.color != null ? this.color.hashCode() : 0);
        result = 31 * result + (this.isTrader ? 1 : 0);
        return result;
    }

    @Override
    protected boolean equals_i(EntityData<?> data) {
        if (!(data instanceof LlamaData)) {
            return false;
        }
        LlamaData other = (LlamaData)data;
        return this.isTrader == other.isTrader && other.color == this.color;
    }

    @Override
    public boolean isSupertypeOf(EntityData<?> data) {
        if (!(data instanceof LlamaData)) {
            return false;
        }
        LlamaData other = (LlamaData)data;
        if (this.isTrader && !other.isTrader) {
            return false;
        }
        return this.color == null || this.color == other.color;
    }

    static {
        EntityData.register(LlamaData.class, "llama", Llama.class, 0, "llama", "creamy llama", "white llama", "brown llama", "gray llama", "trader llama", "creamy trader llama", "white trader llama", "brown trader llama", "gray trader llama");
    }
}

