/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.entity;

import ch.njol.skript.Skript;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import java.util.Objects;
import org.bukkit.entity.Frog;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FrogData
extends EntityData<Frog> {
    @Nullable
    private Frog.Variant variant = null;

    public FrogData() {
    }

    public FrogData(@Nullable Frog.Variant variant) {
        this.variant = variant;
        this.matchedPattern = 0;
        if (variant == Frog.Variant.TEMPERATE) {
            this.matchedPattern = 1;
        }
        if (variant == Frog.Variant.WARM) {
            this.matchedPattern = 2;
        }
        if (variant == Frog.Variant.COLD) {
            this.matchedPattern = 3;
        }
    }

    @Override
    protected boolean init(Literal<?>[] exprs, int matchedPattern, SkriptParser.ParseResult parseResult) {
        switch (matchedPattern) {
            case 1: {
                this.variant = Frog.Variant.TEMPERATE;
                break;
            }
            case 2: {
                this.variant = Frog.Variant.WARM;
                break;
            }
            case 3: {
                this.variant = Frog.Variant.COLD;
            }
        }
        return true;
    }

    @Override
    protected boolean init(@Nullable Class<? extends Frog> c, @Nullable Frog frog) {
        if (frog != null) {
            this.variant = frog.getVariant();
        }
        return true;
    }

    @Override
    public void set(Frog entity) {
        if (this.variant != null) {
            entity.setVariant(this.variant);
        }
    }

    @Override
    protected boolean match(Frog entity) {
        return this.variant == null || this.variant == entity.getVariant();
    }

    @Override
    public Class<? extends Frog> getType() {
        return Frog.class;
    }

    @Override
    @NotNull
    public EntityData getSuperType() {
        return new FrogData(this.variant);
    }

    @Override
    protected int hashCode_i() {
        return Objects.hashCode(this.variant);
    }

    @Override
    protected boolean equals_i(EntityData<?> data) {
        if (!(data instanceof FrogData)) {
            return false;
        }
        return this.variant == ((FrogData)data).variant;
    }

    @Override
    public boolean isSupertypeOf(EntityData<?> data) {
        if (!(data instanceof FrogData)) {
            return false;
        }
        return this.variant == null || this.variant == ((FrogData)data).variant;
    }

    static {
        if (Skript.classExists("org.bukkit.entity.Frog")) {
            EntityData.register(FrogData.class, "frog", Frog.class, 0, "frog", "temperate frog", "warm frog", "cold frog");
        }
    }
}

