/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.entity;

import ch.njol.skript.Skript;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.registrations.Classes;
import ch.njol.util.coll.CollectionUtils;
import com.google.common.collect.Iterators;
import java.util.Objects;
import org.bukkit.entity.Chicken;
import org.jetbrains.annotations.Nullable;

public class ChickenData
extends EntityData<Chicken> {
    private static final boolean VARIANTS_ENABLED;
    private static final Object[] variants;
    @Nullable
    private Object variant = null;

    public ChickenData() {
    }

    public ChickenData(@Nullable Object variant) {
        this.variant = variant;
    }

    @Override
    protected boolean init(Literal<?>[] exprs, int matchedPattern, SkriptParser.ParseResult parseResult) {
        if (VARIANTS_ENABLED) {
            Literal<?> expr = null;
            if (exprs[0] != null) {
                expr = exprs[0];
            } else if (exprs[1] != null) {
                expr = exprs[1];
            }
            if (expr != null) {
                this.variant = expr.getSingle();
            }
        }
        return true;
    }

    @Override
    protected boolean init(@Nullable Class<? extends Chicken> entityClass, @Nullable Chicken chicken) {
        if (chicken != null && VARIANTS_ENABLED) {
            this.variant = chicken.getVariant();
        }
        return true;
    }

    @Override
    public void set(Chicken chicken) {
        if (VARIANTS_ENABLED) {
            Object finalVariant;
            Object object = finalVariant = this.variant != null ? this.variant : CollectionUtils.getRandom(variants);
            assert (finalVariant != null);
            chicken.setVariant((Chicken.Variant)finalVariant);
        }
    }

    @Override
    protected boolean match(Chicken chicken) {
        return this.variant == null || this.variant == chicken.getVariant();
    }

    @Override
    public Class<? extends Chicken> getType() {
        return Chicken.class;
    }

    @Override
    public EntityData<Chicken> getSuperType() {
        return new ChickenData();
    }

    @Override
    protected int hashCode_i() {
        return Objects.hashCode(this.variant);
    }

    @Override
    protected boolean equals_i(EntityData<?> obj) {
        if (!(obj instanceof ChickenData)) {
            return false;
        }
        ChickenData other = (ChickenData)obj;
        return this.variant == other.variant;
    }

    @Override
    public boolean isSupertypeOf(EntityData<?> entityData) {
        if (!(entityData instanceof ChickenData)) {
            return false;
        }
        ChickenData other = (ChickenData)entityData;
        return this.variant == null || this.variant == other.variant;
    }

    static {
        ChickenData.register(ChickenData.class, "chicken", Chicken.class, "chicken");
        if (Skript.classExists("org.bukkit.entity.Chicken$Variant")) {
            VARIANTS_ENABLED = true;
            variants = Iterators.toArray(Classes.getExactClassInfo(Chicken.Variant.class).getSupplier().get(), Chicken.Variant.class);
        } else {
            VARIANTS_ENABLED = false;
            variants = null;
        }
    }

    public static class ChickenVariantDummy {
    }
}

