/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.entity;

import ch.njol.skript.Skript;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import org.bukkit.entity.Axolotl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AxolotlData
extends EntityData<Axolotl> {
    @Nullable
    private Axolotl.Variant variant = null;

    public AxolotlData() {
    }

    public AxolotlData(@Nullable Axolotl.Variant variant) {
        this.variant = variant;
        this.matchedPattern = variant != null ? variant.ordinal() + 1 : 0;
    }

    @Override
    protected boolean init(Literal<?>[] exprs, int matchedPattern, SkriptParser.ParseResult parseResult) {
        if (matchedPattern > 0) {
            this.variant = Axolotl.Variant.values()[matchedPattern - 1];
        }
        return true;
    }

    @Override
    protected boolean init(@Nullable Class<? extends Axolotl> c, @Nullable Axolotl axolotl) {
        if (axolotl != null) {
            this.variant = axolotl.getVariant();
        }
        return true;
    }

    @Override
    public void set(Axolotl entity) {
        if (this.variant != null) {
            entity.setVariant(this.variant);
        }
    }

    @Override
    protected boolean match(Axolotl entity) {
        return this.variant == null || this.variant == entity.getVariant();
    }

    @Override
    public Class<? extends Axolotl> getType() {
        return Axolotl.class;
    }

    @Override
    @NotNull
    public EntityData getSuperType() {
        return new AxolotlData(this.variant);
    }

    @Override
    protected int hashCode_i() {
        return this.variant != null ? this.variant.hashCode() : 0;
    }

    @Override
    protected boolean equals_i(EntityData<?> data) {
        if (!(data instanceof AxolotlData)) {
            return false;
        }
        return this.variant == ((AxolotlData)data).variant;
    }

    @Override
    public boolean isSupertypeOf(EntityData<?> data) {
        if (!(data instanceof AxolotlData)) {
            return false;
        }
        return this.variant == null || this.variant == ((AxolotlData)data).variant;
    }

    static {
        if (Skript.classExists("org.bukkit.entity.Axolotl")) {
            EntityData.register(AxolotlData.class, "axolotl", Axolotl.class, 0, "axolotl", "lucy axolotl", "wild axolotl", "gold axolotl", "cyan axolotl", "blue axolotl");
        }
    }
}

