/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.RequiredPlugins;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.OfflinePlayer;

@Name(value="Is Online")
@Description(value={"Checks whether a player is online. The 'connected' pattern will return false once this player leaves the server, even if they rejoin. Be aware that using the 'connected' pattern with a variable will not have this special behavior. Use the direct event-player or other non-variable expression for best results."})
@Examples(value={"player is online", "player-argument is offline", "while player is connected:", "\twait 60 seconds", "\tsend \"hello!\" to player", "", "# The following will act like `{_player} is online`.", "# Using variables with `is connected` will not behave the same as with non-variables.", "while {_player} is connected:", "\tbroadcast \"online!\"", "\twait 1 tick"})
@Since(value={"1.4"})
@RequiredPlugins(value={"Paper 1.20+ (Connected)"})
public class CondIsOnline
extends PropertyCondition<OfflinePlayer> {
    private boolean connected;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.setExpr(exprs[0]);
        this.setNegated(matchedPattern == 1 ^ parseResult.hasTag("offline"));
        this.connected = parseResult.hasTag("connected");
        return true;
    }

    @Override
    public boolean check(OfflinePlayer op) {
        if (this.connected) {
            return op.isConnected();
        }
        return op.isOnline();
    }

    @Override
    protected String getPropertyName() {
        return this.connected ? "connected" : "online";
    }

    static {
        if (Skript.methodExists(OfflinePlayer.class, "isConnected", new Class[0])) {
            CondIsOnline.register(CondIsOnline.class, "(online|:offline|:connected)", "offlineplayers");
        } else {
            CondIsOnline.register(CondIsOnline.class, "(online|:offline)", "offlineplayers");
        }
    }
}

