/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.conditions;

import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import org.bukkit.entity.Camel;
import org.bukkit.entity.LivingEntity;

@Name(value="Camel Is Dashing")
@Description(value={"Checks whether a camel is currently using its dash ability."})
@Examples(value={"if last spawned camel is dashing:", "\tkill last spawned camel"})
@Since(value={"2.11"})
public class CondIsDashing
extends PropertyCondition<LivingEntity> {
    @Override
    public boolean check(LivingEntity entity) {
        if (entity instanceof Camel) {
            Camel camel = (Camel)entity;
            return camel.isDashing();
        }
        return false;
    }

    @Override
    protected String getPropertyName() {
        return "dashing";
    }

    static {
        CondIsDashing.register(CondIsDashing.class, "dashing", "livingentities");
    }
}

