/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.inventory;

import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftTypes;

public class ServerboundPlaceRecipePacket
implements MinecraftPacket {
    private final int containerId;
    private final int recipe;
    private final boolean useMaxItems;

    public ServerboundPlaceRecipePacket(ByteBuf in) {
        this.containerId = MinecraftTypes.readVarInt(in);
        this.recipe = MinecraftTypes.readVarInt(in);
        this.useMaxItems = in.readBoolean();
    }

    @Override
    public void serialize(ByteBuf out) {
        MinecraftTypes.writeVarInt(out, this.containerId);
        MinecraftTypes.writeVarInt(out, this.recipe);
        out.writeBoolean(this.useMaxItems);
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    public int getContainerId() {
        return this.containerId;
    }

    public int getRecipe() {
        return this.recipe;
    }

    public boolean isUseMaxItems() {
        return this.useMaxItems;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerboundPlaceRecipePacket)) {
            return false;
        }
        ServerboundPlaceRecipePacket other = (ServerboundPlaceRecipePacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getContainerId() != other.getContainerId()) {
            return false;
        }
        if (this.getRecipe() != other.getRecipe()) {
            return false;
        }
        return this.isUseMaxItems() == other.isUseMaxItems();
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ServerboundPlaceRecipePacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getContainerId();
        result = result * 59 + this.getRecipe();
        result = result * 59 + (this.isUseMaxItems() ? 79 : 97);
        return result;
    }

    public @NonNull String toString() {
        return "ServerboundPlaceRecipePacket(containerId=" + this.getContainerId() + ", recipe=" + this.getRecipe() + ", useMaxItems=" + this.isUseMaxItems() + ")";
    }

    public @NonNull ServerboundPlaceRecipePacket withContainerId(int containerId) {
        return this.containerId == containerId ? this : new ServerboundPlaceRecipePacket(containerId, this.recipe, this.useMaxItems);
    }

    public @NonNull ServerboundPlaceRecipePacket withRecipe(int recipe) {
        return this.recipe == recipe ? this : new ServerboundPlaceRecipePacket(this.containerId, recipe, this.useMaxItems);
    }

    public @NonNull ServerboundPlaceRecipePacket withUseMaxItems(boolean useMaxItems) {
        return this.useMaxItems == useMaxItems ? this : new ServerboundPlaceRecipePacket(this.containerId, this.recipe, useMaxItems);
    }

    public ServerboundPlaceRecipePacket(int containerId, int recipe, boolean useMaxItems) {
        this.containerId = containerId;
        this.recipe = recipe;
        this.useMaxItems = useMaxItems;
    }
}

