/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.data.game.item.component;

import java.util.HashMap;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.BooleanComponentType;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponent;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponentType;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.IntComponentType;
import org.jetbrains.annotations.Nullable;

public class DataComponents {
    private final Map<DataComponentType<?>, DataComponent<?, ?>> dataComponents;

    @Nullable
    public <T> T get(DataComponentType<T> type) {
        DataComponent<?, ?> component = this.dataComponents.get(type);
        return component == null ? null : (T)component.getValue();
    }

    public <T> T getOrDefault(DataComponentType<T> type, T def) {
        T value = this.get(type);
        return value != null ? value : def;
    }

    public <T> void put(DataComponentType<T> type, @Nullable T value) {
        if (value == null) {
            this.dataComponents.put(type, type.readNullDataComponent());
        } else if (type instanceof IntComponentType) {
            IntComponentType intType = (IntComponentType)type;
            this.dataComponents.put(intType, intType.primitiveFactory.createPrimitive(intType, (Integer)value));
        } else if (type instanceof BooleanComponentType) {
            BooleanComponentType boolType = (BooleanComponentType)type;
            this.dataComponents.put(boolType, boolType.primitiveFactory.createPrimitive(boolType, (Boolean)value));
        } else {
            this.dataComponents.put(type, type.dataComponentFactory.create(type, value));
        }
    }

    public boolean contains(DataComponentType<?> component) {
        return this.dataComponents.containsKey(component);
    }

    @Nullable
    public <T> T remove(DataComponentType<T> component) {
        DataComponent<?, ?> removed = this.dataComponents.remove(component);
        return removed == null ? null : (T)removed.getValue();
    }

    public DataComponents clone() {
        return new DataComponents(new HashMap(this.dataComponents));
    }

    public Map<DataComponentType<?>, DataComponent<?, ?>> getDataComponents() {
        return this.dataComponents;
    }

    public boolean equals(@org.checkerframework.checker.nullness.qual.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataComponents)) {
            return false;
        }
        DataComponents other = (DataComponents)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<DataComponentType<?>, DataComponent<?, ?>> this$dataComponents = this.getDataComponents();
        Map<DataComponentType<?>, DataComponent<?, ?>> other$dataComponents = other.getDataComponents();
        return !(this$dataComponents == null ? other$dataComponents != null : !((Object)this$dataComponents).equals(other$dataComponents));
    }

    protected boolean canEqual(@org.checkerframework.checker.nullness.qual.Nullable Object other) {
        return other instanceof DataComponents;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<DataComponentType<?>, DataComponent<?, ?>> $dataComponents = this.getDataComponents();
        result = result * 59 + ($dataComponents == null ? 43 : ((Object)$dataComponents).hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "DataComponents(dataComponents=" + String.valueOf(this.getDataComponents()) + ")";
    }

    public DataComponents(Map<DataComponentType<?>, DataComponent<?, ?>> dataComponents) {
        this.dataComponents = dataComponents;
    }
}

