/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.util;

import java.awt.Color;
import java.util.List;
import java.util.UUID;
import org.cloudburstmc.protocol.bedrock.data.skin.SerializedSkin;
import org.cloudburstmc.protocol.bedrock.packet.PlayerListPacket;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.entity.type.player.AvatarEntity;
import org.geysermc.geyser.session.GeyserSession;

public class PlayerListUtils {
    static final int MAX_PLAYER_LIST_PACKET_ENTRIES = 1000;

    public static void batchSendPlayerList(GeyserSession session, List<PlayerListPacket.Entry> entries, PlayerListPacket.Action action) {
        if (entries.size() > 1000) {
            int batches = entries.size() / 1000 + (entries.size() % 1000 > 0 ? 1 : 0);
            for (int i = 0; i < batches; ++i) {
                int start = i * 1000;
                int end = Math.min(start + 1000, entries.size());
                PlayerListPacket packet = new PlayerListPacket();
                packet.setAction(action);
                packet.getEntries().addAll(entries.subList(start, end));
                session.sendUpstreamPacket(packet);
            }
        } else {
            PlayerListPacket packet = new PlayerListPacket();
            packet.setAction(action);
            packet.getEntries().addAll(entries);
            session.sendUpstreamPacket(packet);
        }
    }

    public static PlayerListPacket.Entry forSkullPlayerEntity(AvatarEntity entity, SerializedSkin skin) {
        PlayerListPacket.Entry entry = new PlayerListPacket.Entry(entity.uuid());
        entry.setName(entity.getUsername());
        entry.setEntityId(entity.geyserId());
        entry.setSkin(skin);
        entry.setXuid("");
        entry.setPlatformChatId("");
        entry.setTeacher(false);
        entry.setTrustedSkin(true);
        entry.setColor(Color.LIGHT_GRAY);
        return entry;
    }

    public static PlayerListPacket.Entry buildEntryManually(GeyserSession session, UUID uuid, String username, long geyserId, SerializedSkin skin, Color color) {
        String xuid = "";
        GeyserSession playerSession = GeyserImpl.getInstance().connectionByUuid(uuid);
        if (playerSession != null) {
            xuid = playerSession.getAuthData().xuid();
        } else if (uuid.version() == 0) {
            xuid = Long.toString(uuid.getLeastSignificantBits());
        }
        PlayerListPacket.Entry entry = session.getPlayerEntity().uuid().equals(uuid) ? new PlayerListPacket.Entry(session.getAuthData().uuid()) : new PlayerListPacket.Entry(uuid);
        entry.setName(username);
        entry.setEntityId(geyserId);
        entry.setSkin(skin);
        entry.setXuid(xuid);
        entry.setPlatformChatId("");
        entry.setTeacher(false);
        entry.setTrustedSkin(true);
        entry.setColor(color);
        return entry;
    }

    public static void sendSkinUsingPlayerList(GeyserSession session, PlayerListPacket.Entry entry, AvatarEntity entity, boolean persistent) {
        PlayerListPacket listPacket = new PlayerListPacket();
        listPacket.setAction(PlayerListPacket.Action.ADD);
        listPacket.getEntries().add(entry);
        session.sendUpstreamPacket(listPacket);
        if (!persistent) {
            PlayerListPacket unlistPacket = new PlayerListPacket();
            unlistPacket.setAction(PlayerListPacket.Action.REMOVE);
            unlistPacket.getEntries().add(new PlayerListPacket.Entry(entity.uuid()));
            session.sendUpstreamPacket(unlistPacket);
        }
    }
}

