/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.util;

import org.cloudburstmc.math.TrigMath;
import org.cloudburstmc.math.vector.Vector3f;

public class MathUtils {
    public static final double SQRT_OF_TWO = Math.sqrt(2.0);

    public static Vector3f xYRot(Vector3f velocity, float pitch, float yaw) {
        float pitchCos = TrigMath.cos(pitch);
        float pitchSin = TrigMath.sin(pitch);
        float yawCos = TrigMath.cos(yaw);
        float yawSin = TrigMath.sin(yaw);
        float e = velocity.getY() * pitchCos + velocity.getZ() * pitchSin;
        float i = velocity.getZ() * pitchCos - velocity.getY() * pitchSin;
        velocity = Vector3f.from(velocity.getX(), e, i);
        float d1 = velocity.getX() * yawCos + velocity.getZ() * yawSin;
        float i1 = velocity.getZ() * yawCos - velocity.getX() * yawSin;
        return Vector3f.from(d1, e, i1);
    }

    public static Vector3f calculateViewVector(float pitch, float yaw) {
        float var3 = pitch * ((float)Math.PI / 180);
        float var4 = -yaw * ((float)Math.PI / 180);
        float var5 = TrigMath.cos(var4);
        float var6 = TrigMath.sin(var4);
        float var7 = TrigMath.cos(var3);
        float var8 = TrigMath.sin(var3);
        return Vector3f.from(var6 * var7, -var8, var5 * var7);
    }

    public static float wrapDegrees(float degrees) {
        if ((degrees %= 360.0f) < -180.0f) {
            degrees += 360.0f;
        } else if (degrees >= 180.0f) {
            degrees -= 360.0f;
        }
        return degrees;
    }

    public static float wrapDegrees(double degrees) {
        return MathUtils.wrapDegrees((float)degrees);
    }

    public static int wrapDegreesToInt(float degrees) {
        return (int)MathUtils.wrapDegrees(degrees);
    }

    public static float unwrapDegrees(float degrees) {
        return (degrees % 360.0f + 360.0f) % 360.0f;
    }

    public static float unwrapDegrees(double degrees) {
        return MathUtils.unwrapDegrees((float)degrees);
    }

    public static int unwrapDegreesToInt(float degrees) {
        return (int)MathUtils.unwrapDegrees(degrees);
    }

    public static int ceil(float floatNumber) {
        int truncated = (int)floatNumber;
        return floatNumber > (float)truncated ? truncated + 1 : truncated;
    }

    public static double constrain(double num, double min, double max) {
        if (num > max) {
            num = max;
        }
        if (num < min) {
            num = min;
        }
        return num;
    }

    public static int constrain(int num, int min, int max) {
        if (num > max) {
            num = max;
        }
        if (num < min) {
            num = min;
        }
        return num;
    }

    public static float clamp(float value, float low, float high) {
        if (value < low) {
            return low;
        }
        if (value > high) {
            return high;
        }
        return value;
    }

    public static long chunkPositionToLong(int x, int z) {
        return ((long)x & 0xFFFFFFFFL) << 32 | (long)z & 0xFFFFFFFFL;
    }
}

