/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.bedrock;

import org.cloudburstmc.protocol.bedrock.packet.NetworkStackLatencyPacket;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;

@Translator(packet=NetworkStackLatencyPacket.class)
public class BedrockNetworkStackLatencyTranslator
extends PacketTranslator<NetworkStackLatencyPacket> {
    @Override
    public void translate(GeyserSession session, NetworkStackLatencyPacket packet) {
        Runnable latencyPing = session.getLatencyPingCache().poll();
        if (latencyPing == null) {
            session.getGeyser().getLogger().debug("Received a latency packet that we don't have a ping for: " + String.valueOf(packet));
            return;
        }
        latencyPing.run();
    }

    @Override
    public boolean shouldExecuteInEventLoop() {
        return false;
    }
}

