/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.session.cache;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import lombok.Generated;
import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.entity.type.Tickable;
import org.geysermc.geyser.entity.type.player.PlayerEntity;
import org.geysermc.geyser.platform.spigot.shaded.it.unimi.dsi.fastutil.ints.Int2LongMap;
import org.geysermc.geyser.platform.spigot.shaded.it.unimi.dsi.fastutil.ints.Int2LongOpenHashMap;
import org.geysermc.geyser.platform.spigot.shaded.it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import org.geysermc.geyser.platform.spigot.shaded.it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import org.geysermc.geyser.platform.spigot.shaded.it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import org.geysermc.geyser.platform.spigot.shaded.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.geysermc.geyser.scoreboard.Scoreboard;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.BossBar;

public class EntityCache {
    private final GeyserSession session;
    private final Long2ObjectMap<Entity> entities = new Long2ObjectOpenHashMap<Entity>();
    private final List<Tickable> tickableEntities = new ObjectArrayList<Tickable>();
    private final Int2LongMap entityIdTranslations = new Int2LongOpenHashMap();
    private final Map<UUID, PlayerEntity> playerEntities = new Object2ObjectOpenHashMap<UUID, PlayerEntity>();
    private final Map<UUID, BossBar> bossBars = new Object2ObjectOpenHashMap<UUID, BossBar>();
    private final AtomicLong nextEntityId = new AtomicLong(2L);

    public EntityCache(GeyserSession session) {
        this.session = session;
    }

    public void spawnEntity(Entity entity) {
        if (this.cacheEntity(entity)) {
            this.session.getWorldCache().getScoreboard().entityRegistered(entity);
            entity.spawnEntity();
            if (entity instanceof Tickable) {
                this.tickableEntities.add((Tickable)((Object)entity));
            }
        }
    }

    public boolean cacheEntity(Entity entity) {
        if (!this.entityIdTranslations.containsKey(entity.getEntityId())) {
            this.entityIdTranslations.put(entity.getEntityId(), entity.geyserId());
            this.entities.put(entity.geyserId(), entity);
            return true;
        }
        return false;
    }

    public void removeEntity(Entity entity) {
        if (entity == null) {
            return;
        }
        if (entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            this.session.getPlayerWithCustomHeads().remove(player.uuid());
        }
        if (entity.isValid()) {
            entity.despawnEntity();
        }
        this.entities.remove(this.entityIdTranslations.remove(entity.getEntityId()));
        this.session.getWorldCache().getScoreboard().entityRemoved(entity);
        if (entity instanceof Tickable) {
            this.tickableEntities.remove(entity);
        }
    }

    public void removeAllEntities() {
        ArrayList entities = new ArrayList(this.entities.values());
        for (Entity entity : entities) {
            this.removeEntity(entity);
        }
        this.session.getPlayerWithCustomHeads().clear();
    }

    public Entity getEntityByGeyserId(long geyserId) {
        return (Entity)this.entities.get(geyserId);
    }

    public Entity getEntityByJavaId(int javaId) {
        if (javaId == this.session.getPlayerEntity().getEntityId()) {
            return this.session.getPlayerEntity();
        }
        return (Entity)this.entities.get(this.entityIdTranslations.get(javaId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPlayerEntity(PlayerEntity entity) {
        Map<UUID, PlayerEntity> map = this.playerEntities;
        synchronized (map) {
            boolean exists;
            boolean bl = exists = this.playerEntities.putIfAbsent(entity.uuid(), entity) != null;
            if (exists) {
                return;
            }
        }
        Scoreboard scoreboard = this.session.getWorldCache().getScoreboard();
        scoreboard.playerRegistered(entity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PlayerEntity getPlayerEntity(UUID uuid) {
        Map<UUID, PlayerEntity> map = this.playerEntities;
        synchronized (map) {
            return this.playerEntities.get(uuid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PlayerEntity> getPlayersByName(String name) {
        ArrayList<PlayerEntity> list = new ArrayList<PlayerEntity>();
        Map<UUID, PlayerEntity> map = this.playerEntities;
        synchronized (map) {
            for (PlayerEntity player : this.playerEntities.values()) {
                if (!name.equals(player.getUsername())) continue;
                list.add(player);
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PlayerEntity removePlayerEntity(UUID uuid) {
        PlayerEntity player;
        Map<UUID, PlayerEntity> map = this.playerEntities;
        synchronized (map) {
            player = this.playerEntities.remove(uuid);
        }
        if (player != null) {
            this.session.getWorldCache().getScoreboard().playerRemoved(player);
        }
        return player;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEachPlayerEntity(Consumer<PlayerEntity> player) {
        Map<UUID, PlayerEntity> map = this.playerEntities;
        synchronized (map) {
            this.playerEntities.values().forEach(player);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllPlayerEntities() {
        Map<UUID, PlayerEntity> map = this.playerEntities;
        synchronized (map) {
            this.playerEntities.clear();
        }
    }

    public void addBossBar(UUID uuid, BossBar bossBar) {
        this.bossBars.put(uuid, bossBar);
        bossBar.addBossBar();
    }

    public BossBar getBossBar(UUID uuid) {
        return this.bossBars.get(uuid);
    }

    public void removeBossBar(UUID uuid) {
        BossBar bossBar = this.bossBars.remove(uuid);
        if (bossBar != null) {
            bossBar.removeBossBar();
        }
    }

    public void updateBossBars() {
        this.bossBars.values().forEach(BossBar::updateBossBar);
    }

    public List<Tickable> getTickableEntities() {
        return this.tickableEntities;
    }

    public void removeAllBossBars() {
        this.bossBars.values().forEach(BossBar::removeBossBar);
        this.bossBars.clear();
    }

    @Generated
    public Long2ObjectMap<Entity> getEntities() {
        return this.entities;
    }

    @Generated
    public AtomicLong getNextEntityId() {
        return this.nextEntityId;
    }
}

