/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.scoreboard;

import java.util.Objects;
import org.geysermc.geyser.platform.spigot.shaded.net.kyori.adventure.text.Component;
import org.geysermc.geyser.scoreboard.Scoreboard;
import org.geysermc.geyser.translator.text.MessageTranslator;
import org.geysermc.mcprotocollib.protocol.data.game.chat.numbers.NumberFormat;

public final class ScoreReference {
    public static final long LAST_UPDATE_DEFAULT = -1L;
    private static final long LAST_UPDATE_REMOVE = -2L;
    private final String name;
    private final boolean hidden;
    private String displayName;
    private int score;
    private NumberFormat numberFormat;
    private long lastUpdate;

    public ScoreReference(Scoreboard scoreboard, String name, int score, Component displayName, NumberFormat format) {
        this.name = name;
        this.hidden = name.startsWith("#");
        this.updateProperties(scoreboard, score, displayName, format);
        this.lastUpdate = -1L;
    }

    public String name() {
        return this.name;
    }

    public boolean hidden() {
        return this.hidden;
    }

    public String displayName() {
        return this.displayName;
    }

    public void displayName(Component displayName, Scoreboard scoreboard) {
        if (this.displayName != null && displayName != null) {
            String convertedDisplayName = MessageTranslator.convertMessage(displayName, scoreboard.session().locale());
            if (!this.displayName.equals(convertedDisplayName)) {
                this.displayName = convertedDisplayName;
                this.markChanged();
            }
            return;
        }
        if (this.displayName != null || displayName != null) {
            this.displayName = MessageTranslator.convertMessage(displayName, scoreboard.session().locale());
            this.markChanged();
        }
    }

    public int score() {
        return this.score;
    }

    private void score(int score) {
        boolean changed = this.score != score;
        this.score = score;
        if (changed) {
            this.markChanged();
        }
    }

    public NumberFormat numberFormat() {
        return this.numberFormat;
    }

    private void numberFormat(NumberFormat numberFormat) {
        if (Objects.equals(this.numberFormat(), numberFormat)) {
            return;
        }
        this.numberFormat = numberFormat;
        this.markChanged();
    }

    public void updateProperties(Scoreboard scoreboard, int score, Component displayName, NumberFormat numberFormat) {
        this.score(score);
        this.displayName(displayName, scoreboard);
        this.numberFormat(numberFormat);
    }

    public long lastUpdate() {
        return this.lastUpdate;
    }

    public boolean isRemoved() {
        return this.lastUpdate == -2L;
    }

    public void markChanged() {
        if (this.lastUpdate == -2L) {
            return;
        }
        this.lastUpdate = System.currentTimeMillis();
    }

    public void markDeleted() {
        this.lastUpdate = -1L;
    }
}

