/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.platform.spigot.world;

import lombok.Generated;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPlaceEvent;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.protocol.bedrock.data.SoundEvent;
import org.cloudburstmc.protocol.bedrock.packet.LevelSoundEventPacket;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.platform.spigot.shaded.it.unimi.dsi.fastutil.objects.Object2IntMap;
import org.geysermc.geyser.platform.spigot.world.manager.GeyserSpigotWorldManager;
import org.geysermc.geyser.registry.BlockRegistries;
import org.geysermc.geyser.session.GeyserSession;

public class GeyserSpigotBlockPlaceListener
implements Listener {
    private final GeyserImpl geyser;
    private final GeyserSpigotWorldManager worldManager;

    @EventHandler
    public void place(BlockPlaceEvent event) {
        GeyserSession session = this.geyser.connectionByUuid(event.getPlayer().getUniqueId());
        if (session == null) {
            return;
        }
        LevelSoundEventPacket placeBlockSoundPacket = new LevelSoundEventPacket();
        placeBlockSoundPacket.setSound(SoundEvent.PLACE);
        placeBlockSoundPacket.setPosition(Vector3f.from(event.getBlockPlaced().getX(), event.getBlockPlaced().getY(), event.getBlockPlaced().getZ()));
        placeBlockSoundPacket.setBabySound(false);
        if (this.worldManager.isLegacy()) {
            placeBlockSoundPacket.setExtraData(session.getBlockMappings().getBedrockBlockId(this.worldManager.getBlockAt(session, event.getBlockPlaced().getX(), event.getBlockPlaced().getY(), event.getBlockPlaced().getZ())));
        } else {
            String javaBlockId = event.getBlockPlaced().getBlockData().getAsString();
            placeBlockSoundPacket.setExtraData(session.getBlockMappings().getBedrockBlockId(((Object2IntMap)BlockRegistries.JAVA_BLOCK_STATE_IDENTIFIER_TO_ID.get()).getOrDefault((Object)javaBlockId, 0)));
        }
        placeBlockSoundPacket.setIdentifier(":");
        session.sendUpstreamPacket(placeBlockSoundPacket);
        session.setLastBlockPlacePosition(null);
        session.setLastBlockPlaced(null);
    }

    @Generated
    public GeyserSpigotBlockPlaceListener(GeyserImpl geyser, GeyserSpigotWorldManager worldManager) {
        this.geyser = geyser;
        this.worldManager = worldManager;
    }
}

