/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.pack.url;

import java.io.IOException;
import java.nio.channels.SeekableByteChannel;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.api.pack.PathPackCodec;
import org.geysermc.geyser.api.pack.UrlPackCodec;
import org.geysermc.geyser.pack.GeyserResourcePack;
import org.geysermc.geyser.pack.ResourcePackHolder;
import org.geysermc.geyser.registry.Registries;
import org.geysermc.geyser.registry.loader.ResourcePackLoader;
import org.geysermc.geyser.text.GeyserLocale;

public class GeyserUrlPackCodec
extends UrlPackCodec {
    private final @NonNull String url;
    private PathPackCodec fallback;

    public GeyserUrlPackCodec(@NonNull String url) throws IllegalArgumentException {
        Objects.requireNonNull(url);
        this.url = url;
    }

    private GeyserUrlPackCodec(@NonNull String url, PathPackCodec fallback) {
        Objects.requireNonNull(url);
        this.fallback = fallback;
        this.url = url;
    }

    @Override
    public byte @NonNull [] sha256() {
        Objects.requireNonNull(this.fallback, "must call #create() before attempting to get the sha256!");
        return this.fallback.sha256();
    }

    @Override
    public long size() {
        Objects.requireNonNull(this.fallback, "must call #create() before attempting to get the size!");
        return this.fallback.size();
    }

    @Override
    public @NonNull SeekableByteChannel serialize() throws IOException {
        Objects.requireNonNull(this.fallback, "must call #create() before attempting to serialize!!");
        return this.fallback.serialize();
    }

    @Override
    public @NonNull GeyserResourcePack create() {
        return this.createBuilder().build();
    }

    @Override
    protected @NonNull GeyserResourcePack.Builder createBuilder() {
        if (this.fallback == null) {
            ((CompletableFuture)((CompletableFuture)ResourcePackLoader.downloadPack(this.url, false).thenAccept(pack -> {
                this.fallback = pack;
            })).exceptionally(throwable -> {
                throw new IllegalStateException(throwable.getCause());
            })).join();
        }
        return ResourcePackLoader.readPack(this);
    }

    @Override
    public @NonNull String url() {
        return this.url;
    }

    public void testForChanges(ResourcePackHolder holder) {
        ((CompletableFuture)ResourcePackLoader.downloadPack(this.url, true).thenAccept(backingPathCodec -> {
            GeyserResourcePack updatedPack = ResourcePackLoader.readPack(backingPathCodec.path()).contentKey(holder.pack().contentKey()).build();
            if (updatedPack.uuid().equals(holder.uuid())) {
                String updatedVersion;
                String currentVersion = holder.version().toString();
                if (currentVersion.equals(updatedVersion = updatedPack.manifest().header().version().toString())) {
                    GeyserImpl.getInstance().getLogger().info("No version or pack change detected: Was the resource pack server down?");
                    return;
                }
                GeyserImpl.getInstance().getLogger().info("Detected a new resource pack version (%s, old version %s) for pack at %s!".formatted(currentVersion, updatedVersion, this.url));
            } else {
                GeyserImpl.getInstance().getLogger().info("Detected a new resource pack at the url %s!".formatted(this.url));
                ((Map)Registries.RESOURCE_PACKS.get()).remove(holder.uuid());
            }
            GeyserResourcePack pack = updatedPack.withCodec(new GeyserUrlPackCodec(this.url, (PathPackCodec)backingPathCodec));
            ((Map)Registries.RESOURCE_PACKS.get()).put(updatedPack.uuid(), holder.withPack(pack));
        })).whenComplete((result, throwable) -> {
            if (throwable != null) {
                GeyserImpl.getInstance().getLogger().error(GeyserLocale.getLocaleStringLog("geyser.resource_pack.broken", this.url), (Throwable)throwable);
                ((Map)Registries.RESOURCE_PACKS.get()).remove(holder.uuid());
            }
        });
    }

    @Generated
    public PathPackCodec getFallback() {
        return this.fallback;
    }
}

