/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.level;

import lombok.Generated;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.data.game.level.map.MapIconType;

public enum BedrockMapIcon {
    ICON_WHITE_ARROW(MapIconType.WHITE_ARROW, 0),
    ICON_ITEM_FRAME(MapIconType.GREEN_ARROW, 7),
    ICON_RED_ARROW(MapIconType.RED_ARROW, 2),
    ICON_BLUE_ARROW(MapIconType.BLUE_ARROW, 3),
    ICON_WHITE_CROSS(MapIconType.WHITE_CROSS, 4, 0, 0, 0),
    ICON_RED_POINTER(MapIconType.RED_POINTER, 5),
    ICON_WHITE_CIRCLE(MapIconType.WHITE_CIRCLE, 6),
    ICON_SMALL_WHITE_CIRCLE(MapIconType.SMALL_WHITE_CIRCLE, 13),
    ICON_MANSION(MapIconType.MANSION, 14),
    ICON_TEMPLE(MapIconType.TEMPLE, 15),
    ICON_WHITE_BANNER(MapIconType.WHITE_BANNER, 13, 255, 255, 255),
    ICON_ORANGE_BANNER(MapIconType.ORANGE_BANNER, 13, 249, 128, 29),
    ICON_MAGENTA_BANNER(MapIconType.MAGENTA_BANNER, 13, 199, 78, 189),
    ICON_LIGHT_BLUE_BANNER(MapIconType.LIGHT_BLUE_BANNER, 13, 58, 179, 218),
    ICON_YELLOW_BANNER(MapIconType.YELLOW_BANNER, 13, 254, 216, 61),
    ICON_LIME_BANNER(MapIconType.LIME_BANNER, 13, 128, 199, 31),
    ICON_PINK_BANNER(MapIconType.PINK_BANNER, 13, 243, 139, 170),
    ICON_GRAY_BANNER(MapIconType.GRAY_BANNER, 13, 71, 79, 82),
    ICON_LIGHT_GRAY_BANNER(MapIconType.LIGHT_GRAY_BANNER, 13, 157, 157, 151),
    ICON_CYAN_BANNER(MapIconType.CYAN_BANNER, 13, 22, 156, 156),
    ICON_PURPLE_BANNER(MapIconType.PURPLE_BANNER, 13, 137, 50, 184),
    ICON_BLUE_BANNER(MapIconType.BLUE_BANNER, 13, 60, 68, 170),
    ICON_BROWN_BANNER(MapIconType.BROWN_BANNER, 13, 131, 84, 50),
    ICON_GREEN_BANNER(MapIconType.GREEN_BANNER, 13, 94, 124, 22),
    ICON_RED_BANNER(MapIconType.RED_BANNER, 13, 176, 46, 38),
    ICON_BLACK_BANNER(MapIconType.BLACK_BANNER, 13, 29, 29, 33),
    ICON_TREASURE_MARKER(MapIconType.TREASURE_MARKER, 4),
    ICON_DESERT_VILLAGE(MapIconType.DESERT_VILLAGE, 17),
    ICON_PLAINS_VILLAGE(MapIconType.PLAINS_VILLAGE, 18),
    ICON_SAVANNA_VILLAGE(MapIconType.SAVANNA_VILLAGE, 19),
    ICON_SNOWY_VILLAGE(MapIconType.SNOWY_VILLAGE, 20),
    ICON_TAIGA_VILLAGE(MapIconType.TAIGA_VILLAGE, 21),
    ICON_JUNGLE_TEMPLE(MapIconType.JUNGLE_TEMPLE, 22),
    ICON_SWAMP_HUT(MapIconType.SWAMP_HUT, 23),
    ICON_TRIAL_CHAMBERS(MapIconType.TRIAL_CHAMBERS, 24);

    private static final BedrockMapIcon[] VALUES;
    private final MapIconType iconType;
    private final int iconID;
    private final int red;
    private final int green;
    private final int blue;

    private BedrockMapIcon(MapIconType iconType, int iconID) {
        this(iconType, iconID, 255, 255, 255);
    }

    private BedrockMapIcon(MapIconType iconType, int iconID, int red, int green, int blue) {
        this.iconType = iconType;
        this.iconID = iconID;
        this.red = red;
        this.green = green;
        this.blue = blue;
    }

    public static @Nullable BedrockMapIcon fromType(MapIconType iconType) {
        for (BedrockMapIcon icon : VALUES) {
            if (!icon.iconType.equals((Object)iconType)) continue;
            return icon;
        }
        return null;
    }

    public int toARGB() {
        int alpha = 255;
        return 0xFF000000 | (this.red & 0xFF) << 16 | (this.green & 0xFF) << 8 | this.blue & 0xFF;
    }

    @Generated
    public int getIconID() {
        return this.iconID;
    }

    static {
        VALUES = BedrockMapIcon.values();
    }
}

