/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.impl.camera;

import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.common.value.qual.IntRange;
import org.cloudburstmc.math.vector.Vector3f;
import org.geysermc.geyser.api.bedrock.camera.CameraEaseType;
import org.geysermc.geyser.api.bedrock.camera.CameraFade;
import org.geysermc.geyser.api.bedrock.camera.CameraPosition;

public record GeyserCameraPosition(CameraFade cameraFade, boolean renderPlayerEffects, boolean playerPositionForAudio, CameraEaseType easeType, float easeSeconds, Vector3f position, @IntRange(from=-90L, to=90L) int rotationX, int rotationY, Vector3f facingPosition) implements CameraPosition
{

    public static class Builder
    implements CameraPosition.Builder {
        private CameraFade cameraFade;
        private boolean renderPlayerEffects;
        private boolean playerPositionForAudio;
        private CameraEaseType easeType;
        private float easeSeconds;
        private Vector3f position;
        private @IntRange(from=-90L, to=90L) int rotationX;
        private int rotationY;
        private Vector3f facingPosition;

        @Override
        public CameraPosition.Builder cameraFade(@Nullable CameraFade cameraFade) {
            this.cameraFade = cameraFade;
            return this;
        }

        @Override
        public CameraPosition.Builder renderPlayerEffects(boolean renderPlayerEffects) {
            this.renderPlayerEffects = renderPlayerEffects;
            return this;
        }

        @Override
        public CameraPosition.Builder playerPositionForAudio(boolean playerPositionForAudio) {
            this.playerPositionForAudio = playerPositionForAudio;
            return this;
        }

        @Override
        public CameraPosition.Builder easeType(@Nullable CameraEaseType easeType) {
            this.easeType = easeType;
            return this;
        }

        @Override
        public CameraPosition.Builder easeSeconds(float easeSeconds) {
            if (easeSeconds < 0.0f) {
                throw new IllegalArgumentException("Camera ease duration cannot be negative!");
            }
            this.easeSeconds = easeSeconds;
            return this;
        }

        @Override
        public CameraPosition.Builder position(@NonNull Vector3f position) {
            Objects.requireNonNull(position, "camera position cannot be null!");
            this.position = position;
            return this;
        }

        @Override
        public CameraPosition.Builder rotationX(int rotationX) {
            if (rotationX < -90 || rotationX > 90) {
                throw new IllegalArgumentException("x-axis rotation needs to be between -90 and 90 degrees.");
            }
            this.rotationX = rotationX;
            return this;
        }

        @Override
        public CameraPosition.Builder rotationY(int rotationY) {
            this.rotationY = rotationY;
            return this;
        }

        @Override
        public CameraPosition.Builder facingPosition(@Nullable Vector3f facingPosition) {
            this.facingPosition = facingPosition;
            return this;
        }

        @Override
        public CameraPosition build() {
            if (this.easeSeconds > 0.0f && this.easeType == null) {
                throw new IllegalArgumentException("Camera ease type cannot be null if ease duration is greater than 0");
            }
            Objects.requireNonNull(this.position, "camera position must be non null!");
            return new GeyserCameraPosition(this.cameraFade, this.renderPlayerEffects, this.playerPositionForAudio, this.easeType, this.easeSeconds, this.position, this.rotationX, this.rotationY, this.facingPosition);
        }
    }
}

