/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type.player;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.protocol.bedrock.data.Ability;
import org.cloudburstmc.protocol.bedrock.data.AbilityLayer;
import org.cloudburstmc.protocol.bedrock.data.GameType;
import org.cloudburstmc.protocol.bedrock.data.PlayerPermission;
import org.cloudburstmc.protocol.bedrock.data.command.CommandPermission;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityDataTypes;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.cloudburstmc.protocol.bedrock.packet.AddPlayerPacket;
import org.cloudburstmc.protocol.bedrock.packet.MovePlayerPacket;
import org.geysermc.geyser.entity.EntityDefinitions;
import org.geysermc.geyser.entity.spawn.EntitySpawnContext;
import org.geysermc.geyser.entity.type.LivingEntity;
import org.geysermc.geyser.entity.type.player.PlayerEntity;
import org.geysermc.geyser.entity.type.player.SessionPlayerEntity;
import org.geysermc.geyser.level.block.Blocks;
import org.geysermc.geyser.platform.spigot.shaded.net.kyori.adventure.text.Component;
import org.geysermc.geyser.skin.SkinManager;
import org.geysermc.geyser.skin.SkullSkinManager;
import org.geysermc.geyser.translator.item.ItemTranslator;
import org.geysermc.geyser.util.ChunkUtils;
import org.geysermc.mcprotocollib.auth.GameProfile;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.EntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.Pose;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.BooleanEntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.ByteEntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.ResolvableProfile;

public abstract class AvatarEntity
extends LivingEntity {
    public static final float SNEAKING_POSE_HEIGHT = 1.5f;
    protected static final List<AbilityLayer> BASE_ABILITY_LAYER;
    protected String username;
    protected @Nullable String texturesProperty;
    private String cachedScore = "";
    private boolean scoreVisible = true;
    private @Nullable Vector3i bedPosition;

    public AvatarEntity(EntitySpawnContext context, String username) {
        super(context);
        this.username = username;
        this.nametag = username;
    }

    @Override
    protected void initializeMetadata() {
        super.initializeMetadata();
        this.dirtyMetadata.put(EntityDataTypes.MARK_VARIANT, 255);
    }

    @Override
    public void spawnEntity() {
        AddPlayerPacket addPlayerPacket = new AddPlayerPacket();
        addPlayerPacket.setUuid(this.uuid);
        addPlayerPacket.setUsername(this.username);
        addPlayerPacket.setRuntimeEntityId(this.geyserId);
        addPlayerPacket.setUniqueEntityId(this.geyserId);
        addPlayerPacket.setPosition(this.position.sub(0.0f, this.definition.offset(), 0.0f));
        addPlayerPacket.setRotation(this.getBedrockRotation());
        addPlayerPacket.setMotion(this.motion);
        addPlayerPacket.setHand(ItemTranslator.translateToBedrock(this.session, this.getMainHandItem()));
        addPlayerPacket.getAdventureSettings().setCommandPermission(CommandPermission.ANY);
        addPlayerPacket.getAdventureSettings().setPlayerPermission(PlayerPermission.MEMBER);
        addPlayerPacket.setDeviceId("");
        addPlayerPacket.setPlatformChatId("");
        addPlayerPacket.setGameType(GameType.SURVIVAL);
        addPlayerPacket.setAbilityLayers(BASE_ABILITY_LAYER);
        addPlayerPacket.getMetadata().putFlags(this.flags);
        this.dirtyMetadata.apply(addPlayerPacket.getMetadata());
        this.setFlagsDirty(false);
        this.valid = true;
        this.session.sendUpstreamPacket(addPlayerPacket);
    }

    @Override
    public boolean shouldLerp() {
        return false;
    }

    @Override
    public void moveAbsoluteRaw(Vector3f position, float yaw, float pitch, float headYaw, boolean isOnGround, boolean teleported) {
        this.setPosition(position);
        this.setYaw(yaw);
        this.setPitch(pitch);
        this.setHeadYaw(headYaw);
        this.setOnGround(isOnGround);
        MovePlayerPacket movePlayerPacket = new MovePlayerPacket();
        movePlayerPacket.setRuntimeEntityId(this.geyserId);
        movePlayerPacket.setPosition(this.position);
        movePlayerPacket.setRotation(this.getBedrockRotation());
        movePlayerPacket.setOnGround(isOnGround);
        movePlayerPacket.setMode(this instanceof SessionPlayerEntity || teleported ? MovePlayerPacket.Mode.TELEPORT : MovePlayerPacket.Mode.NORMAL);
        if (movePlayerPacket.getMode() == MovePlayerPacket.Mode.TELEPORT) {
            movePlayerPacket.setTeleportationCause(MovePlayerPacket.TeleportationCause.BEHAVIOR);
        }
        this.session.sendUpstreamPacket(movePlayerPacket);
        if (teleported && !(this instanceof SessionPlayerEntity)) {
            this.updateHeadLookRotation(headYaw);
        }
    }

    @Override
    public void moveRelativeRaw(double relX, double relY, double relZ, float yaw, float pitch, float headYaw, boolean isOnGround) {
        this.setYaw(yaw);
        this.setPitch(pitch);
        this.setHeadYaw(headYaw);
        this.position = Vector3f.from((double)this.position.getX() + relX, (double)this.position.getY() + relY, (double)this.position.getZ() + relZ);
        this.setOnGround(isOnGround);
        MovePlayerPacket movePlayerPacket = new MovePlayerPacket();
        movePlayerPacket.setRuntimeEntityId(this.geyserId);
        movePlayerPacket.setPosition(this.position);
        movePlayerPacket.setRotation(this.getBedrockRotation());
        movePlayerPacket.setOnGround(isOnGround);
        movePlayerPacket.setMode(this instanceof SessionPlayerEntity ? MovePlayerPacket.Mode.TELEPORT : MovePlayerPacket.Mode.NORMAL);
        if (this.getFlag(EntityFlag.SLEEPING) && this.bedPosition != null && (this.bedPosition.getY() == 0 || this.bedPosition.distanceSquared(this.position.toInt()) > 4)) {
            movePlayerPacket.setPosition(Vector3f.from(this.position.getX(), this.position.getY() - this.definition.offset() + 0.2f, this.position.getZ()));
            movePlayerPacket.setMode(MovePlayerPacket.Mode.TELEPORT);
        }
        if (movePlayerPacket.getMode() == MovePlayerPacket.Mode.TELEPORT) {
            movePlayerPacket.setTeleportationCause(MovePlayerPacket.TeleportationCause.BEHAVIOR);
        }
        this.session.sendUpstreamPacket(movePlayerPacket);
    }

    @Override
    public void setPosition(Vector3f position) {
        if (this.bedPosition != null) {
            super.setPosition(position.up(0.2f));
        } else {
            super.setPosition(position.add(0.0f, this.definition.offset(), 0.0f));
        }
    }

    @Override
    public @Nullable Vector3i setBedPosition(EntityMetadata<Optional<Vector3i>, ?> entityMetadata) {
        this.bedPosition = super.setBedPosition(entityMetadata);
        if (this.bedPosition == null) {
            this.dirtyMetadata.put(EntityDataTypes.PLAYER_FLAGS, (byte)0);
            return null;
        }
        this.setPosition(this.bedPosition.toFloat());
        int bed = this.session.getGeyser().getWorldManager().getBlockAt(this.session, this.bedPosition);
        ChunkUtils.updateBlock(this.session, bed, this.bedPosition);
        this.dirtyMetadata.put(EntityDataTypes.PLAYER_FLAGS, (byte)2);
        return this.bedPosition;
    }

    public void setSkin(ResolvableProfile profile, boolean cape) {
        SkinManager.resolveProfile(profile).thenAccept(resolved -> this.setSkin((GameProfile)resolved, cape, null));
    }

    public void setSkin(GameProfile profile, boolean cape, @Nullable Runnable after) {
        GameProfile.Property textures = profile.getProperty("textures");
        if (textures != null) {
            this.setSkin(textures.getValue(), cape, after);
        } else {
            this.setSkin((String)null, cape, after);
        }
    }

    public void setSkin(String texturesProperty, boolean cape, @Nullable Runnable after) {
        if (Objects.equals(texturesProperty, this.texturesProperty)) {
            return;
        }
        this.texturesProperty = texturesProperty;
        if (cape) {
            SkinManager.requestAndHandleSkinAndCape(this, this.session, after == null ? null : skin -> after.run());
        } else {
            SkullSkinManager.requestAndHandleSkin(this, this.session, after == null ? null : skin -> after.run());
        }
    }

    public void setSkinVisibility(ByteEntityMetadata entityMetadata) {
        this.dirtyMetadata.put(EntityDataTypes.MARK_VARIANT, ~entityMetadata.getPrimitiveValue() & 0xFF);
    }

    @Override
    public String getDisplayName() {
        return this.username;
    }

    @Override
    public void setDisplayName(EntityMetadata<Optional<Component>, ?> entityMetadata) {
        if (!(this instanceof PlayerEntity)) {
            super.setDisplayName(entityMetadata);
        }
    }

    @Override
    public void setDisplayNameVisible(BooleanEntityMetadata entityMetadata) {
        if (!(this instanceof PlayerEntity)) {
            super.setDisplayNameVisible(entityMetadata);
        }
    }

    public void setBelowNameText(String text) {
        if (text == null) {
            text = "";
        }
        boolean changed = !Objects.equals(this.cachedScore, text);
        this.cachedScore = text;
        if (this.scoreVisible && changed) {
            this.dirtyMetadata.put(EntityDataTypes.SCORE, text);
        }
    }

    public abstract boolean isListed();

    @Override
    protected void scoreVisibility(boolean show) {
        boolean visibilityChanged = this.scoreVisible != show;
        this.scoreVisible = show;
        if (!visibilityChanged) {
            return;
        }
        if (this.cachedScore.isEmpty()) {
            return;
        }
        this.dirtyMetadata.put(EntityDataTypes.SCORE, show ? this.cachedScore : "");
    }

    @Override
    public void setPose(Pose pose) {
        super.setPose(pose);
        this.setFlag(EntityFlag.SWIMMING, false);
        this.setFlag(EntityFlag.CRAWLING, false);
        if (pose == Pose.SWIMMING) {
            if (this.session.getGeyser().getWorldManager().blockAt(this.session, this.position.down(EntityDefinitions.PLAYER.offset()).toInt()).is(Blocks.WATER)) {
                this.setFlag(EntityFlag.SWIMMING, true);
            } else {
                this.setFlag(EntityFlag.CRAWLING, true);
                if (!(this instanceof SessionPlayerEntity)) {
                    this.updateRotation(this.yaw, 0.0f, this.onGround);
                }
            }
        }
    }

    @Override
    public void setPitch(float pitch) {
        super.setPitch(this.getFlag(EntityFlag.CRAWLING) ? 0.0f : pitch);
    }

    @Override
    public void setDimensionsFromPose(Pose pose) {
        float width;
        float height;
        switch (pose) {
            case SNEAKING: {
                height = 1.5f;
                width = this.definition.width();
                break;
            }
            case FALL_FLYING: 
            case SPIN_ATTACK: 
            case SWIMMING: {
                height = 0.6f;
                width = this.definition.width();
                break;
            }
            case DYING: {
                height = 0.2f;
                width = 0.2f;
                break;
            }
            default: {
                super.setDimensionsFromPose(pose);
                return;
            }
        }
        this.setBoundingBoxWidth(width);
        this.setBoundingBoxHeight(height);
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public @Nullable String getTexturesProperty() {
        return this.texturesProperty;
    }

    @Generated
    public void setTexturesProperty(@Nullable String texturesProperty) {
        this.texturesProperty = texturesProperty;
    }

    @Generated
    public @Nullable Vector3i getBedPosition() {
        return this.bedPosition;
    }

    static {
        AbilityLayer abilityLayer = new AbilityLayer();
        abilityLayer.setLayerType(AbilityLayer.Type.BASE);
        Ability[] abilities = Ability.values();
        Collections.addAll(abilityLayer.getAbilitiesSet(), abilities);
        Collections.addAll(abilityLayer.getAbilityValues(), abilities);
        BASE_ABILITY_LAYER = Collections.singletonList(abilityLayer);
    }
}

