/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type.living.animal;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.geysermc.geyser.entity.spawn.EntitySpawnContext;
import org.geysermc.geyser.entity.type.living.animal.AnimalEntity;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.session.cache.tags.ItemTag;
import org.geysermc.geyser.session.cache.tags.Tag;
import org.geysermc.geyser.util.InteractionResult;
import org.geysermc.geyser.util.InteractiveTag;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.Hand;

public class OcelotEntity
extends AnimalEntity {
    public OcelotEntity(EntitySpawnContext context) {
        super(context);
    }

    @Override
    protected @Nullable Tag<Item> getFoodTag() {
        return ItemTag.OCELOT_FOOD;
    }

    @Override
    protected @NonNull InteractiveTag testMobInteraction(@NonNull Hand hand, @NonNull GeyserItemStack itemInHand) {
        if (!this.getFlag(EntityFlag.TRUSTING) && this.canEat(itemInHand) && this.session.getPlayerEntity().getPosition().distanceSquared(this.position) < 9.0f) {
            return InteractiveTag.FEED;
        }
        return super.testMobInteraction(hand, itemInHand);
    }

    @Override
    protected @NonNull InteractionResult mobInteract(@NonNull Hand hand, @NonNull GeyserItemStack itemInHand) {
        if (!this.getFlag(EntityFlag.TRUSTING) && this.canEat(itemInHand) && this.session.getPlayerEntity().getPosition().distanceSquared(this.position) < 9.0f) {
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(hand, itemInHand);
    }
}

