/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type.living.animal;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityDataTypes;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.geysermc.geyser.entity.spawn.EntitySpawnContext;
import org.geysermc.geyser.entity.type.living.animal.AnimalEntity;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.session.cache.tags.ItemTag;
import org.geysermc.geyser.session.cache.tags.Tag;
import org.geysermc.geyser.util.EntityUtils;
import org.geysermc.geyser.util.InteractionResult;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.BooleanEntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.IntEntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.Hand;

public class AxolotlEntity
extends AnimalEntity {
    public AxolotlEntity(EntitySpawnContext context) {
        super(context);
    }

    public void setVariant(IntEntityMetadata entityMetadata) {
        int variant = entityMetadata.getPrimitiveValue();
        switch (variant) {
            case 1: {
                variant = 3;
                break;
            }
            case 3: {
                variant = 1;
            }
        }
        this.dirtyMetadata.put(EntityDataTypes.VARIANT, variant);
    }

    public void setPlayingDead(BooleanEntityMetadata entityMetadata) {
        this.setFlag(EntityFlag.PLAYING_DEAD, entityMetadata.getPrimitiveValue());
    }

    @Override
    protected @Nullable Tag<Item> getFoodTag() {
        return ItemTag.AXOLOTL_FOOD;
    }

    @Override
    protected short getMaxAir() {
        return 6000;
    }

    @Override
    public boolean canBeLeashed() {
        return true;
    }

    @Override
    protected @NonNull InteractionResult mobInteract(@NonNull Hand hand, @NonNull GeyserItemStack itemInHand) {
        if (EntityUtils.attemptToBucket(itemInHand)) {
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(hand, itemInHand);
    }
}

