/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type;

import lombok.Generated;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityDataTypes;
import org.geysermc.geyser.entity.spawn.EntitySpawnContext;
import org.geysermc.geyser.entity.type.DisplayBaseEntity;
import org.geysermc.geyser.platform.spigot.shaded.net.kyori.adventure.text.Component;
import org.geysermc.geyser.platform.spigot.shaded.net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.geysermc.geyser.translator.text.MessageTranslator;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.EntityMetadata;
import org.jetbrains.annotations.Nullable;

public class TextDisplayEntity
extends DisplayBaseEntity {
    private static final float LINE_HEIGHT_OFFSET = 0.1414f;
    private int lineCount;

    public TextDisplayEntity(EntitySpawnContext context) {
        super(context);
    }

    public float calculateLineOffset() {
        if (this.lineCount == 0) {
            return 0.0f;
        }
        return -0.6f + 0.1414f * (float)this.lineCount;
    }

    @Override
    public void moveAbsoluteRaw(Vector3f position, float yaw, float pitch, float headYaw, boolean isOnGround, boolean teleported) {
        super.moveAbsoluteRaw(position.up(this.calculateLineOffset()), yaw, pitch, headYaw, isOnGround, teleported);
    }

    @Override
    protected void initializeMetadata() {
        super.initializeMetadata();
        this.dirtyMetadata.put(EntityDataTypes.HITBOX, NbtMap.EMPTY);
        this.dirtyMetadata.put(EntityDataTypes.SCALE, Float.valueOf(0.0f));
        this.dirtyMetadata.put(EntityDataTypes.NAMETAG_ALWAYS_SHOW, (byte)1);
    }

    public void setText(EntityMetadata<Component, ?> entityMetadata) {
        this.dirtyMetadata.put(EntityDataTypes.NAME, MessageTranslator.convertMessage(entityMetadata.getValue(), this.session.locale()));
        int newLineCount = this.calculateLineCount(entityMetadata.getValue());
        if (this.lineCount != newLineCount) {
            Vector3f positionWithoutOffset = this.position.down(this.calculateLineOffset());
            this.lineCount = newLineCount;
            this.moveAbsoluteRaw(positionWithoutOffset, this.yaw, this.pitch, this.headYaw, this.onGround, false);
        }
    }

    private int calculateLineCount(@Nullable Component text) {
        if (text == null) {
            return 0;
        }
        return PlainTextComponentSerializer.plainText().serialize(text).split("\n").length;
    }

    @Generated
    public int getLineCount() {
        return this.lineCount;
    }
}

