/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.util;

import java.util.UUID;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class LinkedPlayer
implements Cloneable {
    private final String javaUsername;
    private final UUID javaUniqueId;
    private final UUID bedrockId;
    private boolean fromDifferentPlatform = false;

    public static LinkedPlayer of(String javaUsername, UUID javaUniqueId, UUID bedrockId) {
        return new LinkedPlayer(javaUsername, javaUniqueId, bedrockId);
    }

    public static @Nullable LinkedPlayer fromString(String data) {
        String[] split = data.split(";");
        if (split.length != 3) {
            return null;
        }
        LinkedPlayer player = new LinkedPlayer(split[0], UUID.fromString(split[1]), UUID.fromString(split[2]));
        player.fromDifferentPlatform = true;
        return player;
    }

    public String toString() {
        return this.javaUsername + ';' + this.javaUniqueId.toString() + ';' + this.bedrockId.toString();
    }

    public LinkedPlayer clone() throws CloneNotSupportedException {
        return (LinkedPlayer)super.clone();
    }

    @Generated
    public String getJavaUsername() {
        return this.javaUsername;
    }

    @Generated
    public UUID getJavaUniqueId() {
        return this.javaUniqueId;
    }

    @Generated
    public UUID getBedrockId() {
        return this.bedrockId;
    }

    @Generated
    public boolean isFromDifferentPlatform() {
        return this.fromDifferentPlatform;
    }

    @Generated
    private LinkedPlayer(String javaUsername, UUID javaUniqueId, UUID bedrockId) {
        this.javaUsername = javaUsername;
        this.javaUniqueId = javaUniqueId;
        this.bedrockId = bedrockId;
    }
}

