/*
 * Decompiled with CFR 0.152.
 */
package org.cloudburstmc.protocol.bedrock.packet;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.util.ReferenceCounted;
import org.cloudburstmc.protocol.bedrock.codec.BedrockCodecHelper;
import org.cloudburstmc.protocol.bedrock.codec.BedrockPacketSerializer;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacketHandler;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacketType;
import org.cloudburstmc.protocol.common.PacketSignal;

public final class UnknownPacket
implements BedrockPacket,
BedrockPacketSerializer<UnknownPacket>,
ReferenceCounted {
    private int packetId;
    private ByteBuf payload;

    @Override
    public void serialize(ByteBuf buffer, BedrockCodecHelper helper, UnknownPacket packet) {
        buffer.writeBytes(packet.payload, packet.payload.readerIndex(), packet.payload.readableBytes());
    }

    @Override
    public void deserialize(ByteBuf buffer, BedrockCodecHelper helper, UnknownPacket packet) {
        packet.payload = buffer.readRetainedSlice(buffer.readableBytes());
    }

    public String toString() {
        return "UNKNOWN - " + this.getPacketId() + " - Hex: " + (this.payload == null || this.payload.refCnt() == 0 ? "null" : ByteBufUtil.hexDump((ByteBuf)this.payload));
    }

    @Override
    public final PacketSignal handle(BedrockPacketHandler handler) {
        return PacketSignal.UNHANDLED;
    }

    @Override
    public BedrockPacketType getPacketType() {
        return BedrockPacketType.UNKNOWN;
    }

    public int refCnt() {
        return this.payload == null ? 0 : this.payload.refCnt();
    }

    public UnknownPacket retain() {
        if (this.payload != null) {
            this.payload.retain();
        }
        return this;
    }

    public UnknownPacket retain(int increment) {
        if (this.payload != null) {
            this.payload.retain(increment);
        }
        return this;
    }

    public UnknownPacket touch() {
        if (this.payload != null) {
            this.payload.touch();
        }
        return this;
    }

    public UnknownPacket touch(Object hint) {
        if (this.payload != null) {
            this.payload.touch(hint);
        }
        return this;
    }

    public boolean release() {
        return this.payload == null || this.payload.release();
    }

    public boolean release(int decrement) {
        return this.payload == null || this.payload.release(decrement);
    }

    @Override
    public UnknownPacket clone() {
        throw new UnsupportedOperationException("Can not clone reference counted packet");
    }

    public int getPacketId() {
        return this.packetId;
    }

    public ByteBuf getPayload() {
        return this.payload;
    }

    public void setPacketId(int packetId) {
        this.packetId = packetId;
    }

    public void setPayload(ByteBuf payload) {
        this.payload = payload;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UnknownPacket)) {
            return false;
        }
        UnknownPacket other = (UnknownPacket)o;
        if (this.packetId != other.packetId) {
            return false;
        }
        ByteBuf this$payload = this.payload;
        ByteBuf other$payload = other.payload;
        return !(this$payload == null ? other$payload != null : !this$payload.equals(other$payload));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.packetId;
        ByteBuf $payload = this.payload;
        result = result * 59 + ($payload == null ? 43 : $payload.hashCode());
        return result;
    }
}

