/*
 * Decompiled with CFR 0.152.
 */
package org.cloudburstmc.protocol.bedrock.codec.v291.serializer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cloudburstmc.protocol.bedrock.codec.BedrockCodecHelper;
import org.cloudburstmc.protocol.bedrock.codec.BedrockPacketSerializer;
import org.cloudburstmc.protocol.bedrock.data.auth.AuthPayload;
import org.cloudburstmc.protocol.bedrock.data.auth.CertificateChainPayload;
import org.cloudburstmc.protocol.bedrock.packet.SubClientLoginPacket;
import org.cloudburstmc.protocol.common.util.Preconditions;
import org.cloudburstmc.protocol.common.util.VarInts;
import org.geysermc.geyser.platform.spigot.shaded.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.jose4j.json.JsonUtil;
import org.jose4j.lang.JoseException;

public class SubClientLoginSerializer_v291
implements BedrockPacketSerializer<SubClientLoginPacket> {
    public static final SubClientLoginSerializer_v291 INSTANCE = new SubClientLoginSerializer_v291();

    @Override
    public void serialize(ByteBuf buffer, BedrockCodecHelper helper, SubClientLoginPacket packet) {
        this.writeJwts(buffer, this.writeAuthJwt(packet.getAuthPayload()), packet.getClientJwt());
    }

    @Override
    public void deserialize(ByteBuf buffer, BedrockCodecHelper helper, SubClientLoginPacket packet) {
        ByteBuf jwt = buffer.readSlice(VarInts.readUnsignedInt(buffer));
        String authJwt = this.readString(jwt);
        packet.setAuthPayload(this.readAuthJwt(authJwt));
        String value = (String)jwt.readCharSequence(jwt.readIntLE(), StandardCharsets.UTF_8);
        packet.setClientJwt(value);
    }

    protected String writeAuthJwt(AuthPayload payload) {
        Preconditions.checkArgument(payload instanceof CertificateChainPayload, "This client only supports CertificateChainPayload for login");
        HashMap<String, List<String>> json = new HashMap<String, List<String>>();
        json.put("chain", ((CertificateChainPayload)payload).getChain());
        return JsonUtil.toJson(json);
    }

    protected AuthPayload readAuthJwt(String authJwt) {
        try {
            Map<String, Object> json = JsonUtil.parseJson(authJwt);
            Preconditions.checkArgument(json != null && json.containsKey("chain") && json.get("chain") instanceof List, "Invalid login chain");
            List chain = (List)json.get("chain");
            ObjectArrayList<String> chainList = new ObjectArrayList<String>(3);
            for (Object node : chain) {
                Preconditions.checkArgument(node instanceof String, "Expected String in login chain");
                chainList.add((String)node);
            }
            return new CertificateChainPayload(chainList);
        }
        catch (JoseException e) {
            throw new IllegalArgumentException("Failed to parse auth payload", e);
        }
    }

    protected void writeJwts(ByteBuf buffer, String authJwt, String clientJwt) {
        int authLength = ByteBufUtil.utf8Bytes((CharSequence)authJwt);
        int clientLength = ByteBufUtil.utf8Bytes((CharSequence)clientJwt);
        VarInts.writeUnsignedInt(buffer, authLength + clientLength + 8);
        buffer.writeIntLE(authLength);
        buffer.writeCharSequence((CharSequence)authJwt, StandardCharsets.UTF_8);
        buffer.writeIntLE(clientLength);
        buffer.writeCharSequence((CharSequence)clientJwt, StandardCharsets.UTF_8);
    }

    protected String readString(ByteBuf buffer) {
        return (String)buffer.readCharSequence(buffer.readIntLE(), StandardCharsets.UTF_8);
    }

    protected SubClientLoginSerializer_v291() {
    }
}

