/*
 * Decompiled with CFR 0.152.
 */
package org.cloudburstmc.math.immutable.vector;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.cloudburstmc.math.GenericMath;
import org.cloudburstmc.math.vector.Vector3d;

@ParametersAreNonnullByDefault
@Immutable
public class ImmutableVector3d
extends Vector3d {
    private static final long serialVersionUID = 1L;
    private final double x;
    private final double y;
    private final double z;
    private volatile transient boolean hashed = false;
    private volatile transient int hashCode = 0;

    ImmutableVector3d(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public double getZ() {
        return this.z;
    }

    @Override
    @Nonnull
    public Vector3d add(double x, double y, double z) {
        return Vector3d.from(this.getX() + x, this.getY() + y, this.getZ() + z);
    }

    @Override
    @Nonnull
    public Vector3d sub(double x, double y, double z) {
        return Vector3d.from(this.getX() - x, this.getY() - y, this.getZ() - z);
    }

    @Override
    @Nonnull
    public Vector3d mul(double x, double y, double z) {
        return Vector3d.from(this.getX() * x, this.getY() * y, this.getZ() * z);
    }

    @Override
    @Nonnull
    public Vector3d div(double x, double y, double z) {
        return Vector3d.from(this.getX() / x, this.getY() / y, this.getZ() / z);
    }

    @Override
    @Nonnull
    public Vector3d project(double x, double y, double z) {
        double lengthSquared = x * x + y * y + z * z;
        if (Math.abs(lengthSquared) < GenericMath.DBL_EPSILON) {
            throw new ArithmeticException("Cannot project onto the zero vector");
        }
        double a = this.dot(x, y, z) / lengthSquared;
        return Vector3d.from(a * x, a * y, a * z);
    }

    @Override
    @Nonnull
    public Vector3d cross(double x, double y, double z) {
        return Vector3d.from(this.getY() * z - this.getZ() * y, this.getZ() * x - this.getX() * z, this.getX() * y - this.getY() * x);
    }

    @Override
    @Nonnull
    public Vector3d pow(double power) {
        return Vector3d.from(Math.pow(this.x, power), Math.pow(this.y, power), Math.pow(this.z, power));
    }

    @Override
    @Nonnull
    public Vector3d ceil() {
        return Vector3d.from(Math.ceil(this.getX()), Math.ceil(this.getY()), Math.ceil(this.getZ()));
    }

    @Override
    @Nonnull
    public Vector3d floor() {
        return Vector3d.from(GenericMath.floor(this.getX()), GenericMath.floor(this.getY()), GenericMath.floor(this.getZ()));
    }

    @Override
    @Nonnull
    public Vector3d round() {
        return Vector3d.from(Math.round(this.getX()), Math.round(this.getY()), Math.round(this.getZ()));
    }

    @Override
    @Nonnull
    public Vector3d abs() {
        return Vector3d.from(Math.abs(this.getX()), Math.abs(this.getY()), Math.abs(this.getZ()));
    }

    @Override
    @Nonnull
    public Vector3d negate() {
        return Vector3d.from(-this.getX(), -this.getY(), -this.getZ());
    }

    @Override
    @Nonnull
    public Vector3d min(double x, double y, double z) {
        return Vector3d.from(Math.min(this.getX(), x), Math.min(this.getY(), y), Math.min(this.getZ(), z));
    }

    @Override
    @Nonnull
    public Vector3d max(double x, double y, double z) {
        return Vector3d.from(Math.max(this.getX(), x), Math.max(this.getY(), y), Math.max(this.getZ(), z));
    }

    @Override
    @Nonnull
    public Vector3d up(double v) {
        return Vector3d.from(this.getX(), this.getY() + v, this.getZ());
    }

    @Override
    @Nonnull
    public Vector3d down(double v) {
        return Vector3d.from(this.getX(), this.getY() - v, this.getZ());
    }

    @Override
    @Nonnull
    public Vector3d north(double v) {
        return Vector3d.from(this.getX(), this.getY(), this.getZ() - v);
    }

    @Override
    @Nonnull
    public Vector3d south(double v) {
        return Vector3d.from(this.getX(), this.getY(), this.getZ() + v);
    }

    @Override
    @Nonnull
    public Vector3d east(double v) {
        return Vector3d.from(this.getX() + v, this.getY(), this.getZ());
    }

    @Override
    @Nonnull
    public Vector3d west(double v) {
        return Vector3d.from(this.getX() - v, this.getY(), this.getZ());
    }

    @Override
    @Nonnull
    public Vector3d normalize() {
        double length = this.length();
        if (Math.abs(length) < GenericMath.DBL_EPSILON) {
            throw new ArithmeticException("Cannot normalize the zero vector");
        }
        return Vector3d.from(this.getX() / length, this.getY() / length, this.getZ() / length);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Vector3d)) {
            return false;
        }
        Vector3d vector3 = (Vector3d)o;
        if (Double.compare(vector3.getX(), this.x) != 0) {
            return false;
        }
        if (Double.compare(vector3.getY(), this.y) != 0) {
            return false;
        }
        return Double.compare(vector3.getZ(), this.z) == 0;
    }

    public int hashCode() {
        if (!this.hashed) {
            int result = this.x != 0.0 ? Double.hashCode(this.x) : 0;
            result = 31 * result + (this.y != 0.0 ? Double.hashCode(this.y) : 0);
            this.hashCode = 31 * result + (this.z != 0.0 ? Double.hashCode(this.z) : 0);
            this.hashed = true;
        }
        return this.hashCode;
    }
}

