/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.minecraftauth.xbl.request;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.net.MalformedURLException;
import java.time.Instant;
import net.lenni0451.commons.gson.elements.GsonArray;
import net.lenni0451.commons.gson.elements.GsonObject;
import net.lenni0451.commons.httpclient.HttpResponse;
import net.lenni0451.commons.httpclient.requests.impl.PostRequest;
import net.raphimc.minecraftauth.util.http.content.JsonContent;
import net.raphimc.minecraftauth.xbl.model.XblDeviceToken;
import net.raphimc.minecraftauth.xbl.model.XblTitleToken;
import net.raphimc.minecraftauth.xbl.model.XblUserToken;
import net.raphimc.minecraftauth.xbl.model.XblXstsToken;
import net.raphimc.minecraftauth.xbl.responsehandler.XblResponseHandler;

public class XblXstsAuthorizeRequest
extends PostRequest
implements XblResponseHandler<XblXstsToken> {
    public XblXstsAuthorizeRequest(XblDeviceToken deviceToken, XblUserToken userToken, XblTitleToken titleToken, String relyingParty) throws MalformedURLException {
        super("https://xsts.auth.xboxlive.com/xsts/authorize");
        JsonObject properties = new JsonObject();
        properties.addProperty("SandboxId", "RETAIL");
        if (deviceToken != null) {
            properties.addProperty("DeviceToken", deviceToken.getToken());
        }
        properties.add("UserTokens", (JsonElement)new GsonArray().add(userToken.getToken()).getJsonArray());
        if (titleToken != null) {
            properties.addProperty("TitleToken", titleToken.getToken());
        }
        JsonObject postData = new JsonObject();
        postData.add("Properties", (JsonElement)properties);
        postData.addProperty("RelyingParty", relyingParty);
        postData.addProperty("TokenType", "JWT");
        this.setContent(new JsonContent(postData));
        this.setHeader("x-xbl-contract-version", "1");
    }

    @Override
    public XblXstsToken handle(HttpResponse response, GsonObject json) {
        return new XblXstsToken(Instant.parse(json.reqString("NotAfter")).toEpochMilli(), json.reqString("Token"), json.reqObject("DisplayClaims").reqArray("xui").get(0).asObject().reqString("uhs"));
    }
}

