/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.httpclient;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import javax.annotation.Nullable;
import net.lenni0451.commons.httpclient.HeaderStore;
import net.lenni0451.commons.httpclient.constants.ContentTypes;
import net.lenni0451.commons.httpclient.constants.StatusCodes;
import net.lenni0451.commons.httpclient.content.DelegatingHttpContent;
import net.lenni0451.commons.httpclient.content.HttpContent;
import net.lenni0451.commons.httpclient.content.impl.ByteArrayContent;
import net.lenni0451.commons.httpclient.content.impl.InputStreamContent;
import net.lenni0451.commons.httpclient.model.ContentType;
import org.jetbrains.annotations.ApiStatus;

public class HttpResponse
extends HeaderStore<HttpResponse> {
    private static final Map<String, InputStreamMapper> DEFAULT_DECODERS = new HashMap<String, InputStreamMapper>();
    private final URL url;
    private final int statusCode;
    private final HttpContent content;

    @Nullable
    private static InputStreamMapper getExistingDecoder(String ... decoderClasses) {
        for (String decoderClass : decoderClasses) {
            try {
                Class<InputStream> clazz = Class.forName(decoderClass).asSubclass(InputStream.class);
                Constructor<InputStream> constructor = clazz.getDeclaredConstructor(InputStream.class);
                return inputStream -> {
                    try {
                        return (InputStream)constructor.newInstance(inputStream);
                    }
                    catch (Throwable t) {
                        throw new IOException("Failed to create decoder input stream of type " + decoderClass, t);
                    }
                };
            }
            catch (Throwable throwable) {
            }
        }
        return null;
    }

    public HttpResponse(URL url, int statusCode, byte[] content, Map<String, List<String>> headers) {
        super(headers);
        this.url = url;
        this.statusCode = statusCode;
        this.content = new ByteArrayContent(this.getFirstHeader("Content-Type").map(ContentType::parse).orElse(ContentTypes.APPLICATION_OCTET_STREAM), content);
    }

    public HttpResponse(URL url, int statusCode, InputStream inputStream, Map<String, List<String>> headers) {
        super(headers);
        this.url = url;
        this.statusCode = statusCode;
        this.content = new InputStreamContent(this.getFirstHeader("Content-Type").map(ContentType::parse).orElse(ContentTypes.APPLICATION_OCTET_STREAM), inputStream, this.getFirstHeader("Content-Length").map(s -> {
            try {
                return Integer.valueOf(s);
            }
            catch (NumberFormatException e) {
                return -1;
            }
        }).orElse(-1));
    }

    public HttpResponse(URL url, int statusCode, HttpContent content, Map<String, List<String>> headers) {
        super(headers);
        this.url = url;
        this.statusCode = statusCode;
        this.content = content;
    }

    public URL getURL() {
        return this.url;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getStatusMessage() {
        return StatusCodes.STATUS_CODES.getOrDefault(this.statusCode, "Unknown");
    }

    public HttpContent getContent() {
        return this.content;
    }

    public HttpContent getDecodedContent() {
        return this.getDecodedContent(encoding -> DEFAULT_DECODERS.get(encoding.toLowerCase(Locale.ROOT)));
    }

    public HttpContent getDecodedContent(DecoderProvider decoderProvider) {
        String contentEncoding = this.getFirstHeader("Content-Encoding").orElse(null);
        if (contentEncoding == null) {
            return this.content;
        }
        String[] encodings = contentEncoding.split(",\\s*");
        final ArrayList<InputStreamMapper> decoders = new ArrayList<InputStreamMapper>(encodings.length);
        for (String encoding : encodings) {
            InputStreamMapper decoder = decoderProvider.get(encoding);
            if (decoder == null) {
                return this.content;
            }
            decoders.add(decoder);
        }
        this.removeHeader("Content-Encoding");
        this.setHeader("Original-Content-Encoding", contentEncoding);
        return new DelegatingHttpContent(this.content){

            @Override
            protected InputStream modify(InputStream inputStream) throws IOException {
                inputStream = super.modify(inputStream);
                for (int i = decoders.size() - 1; i >= 0; --i) {
                    inputStream = ((InputStreamMapper)decoders.get(i)).map(inputStream);
                }
                return inputStream;
            }
        };
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public InputStream getInputStream() {
        return this.content.getAsStream();
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public String getContentAsString() {
        return this.content.getAsString();
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public String getContentAsString(Charset charset) {
        return this.content.getAsString(charset);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public Optional<ContentType> getContentType() {
        return this.getFirstHeader("Content-Type").map(ContentType::parse);
    }

    static {
        DEFAULT_DECODERS.put("identity", inputStream -> inputStream);
        DEFAULT_DECODERS.put("gzip", GZIPInputStream::new);
        DEFAULT_DECODERS.put("x-gzip", GZIPInputStream::new);
        DEFAULT_DECODERS.put("deflate", InflaterInputStream::new);
        DEFAULT_DECODERS.put("br", HttpResponse.getExistingDecoder("com.aayushatharva.brotli4j.decoder.BrotliInputStream", "org.brotli.dec.BrotliInputStream"));
        DEFAULT_DECODERS.put("zstd", HttpResponse.getExistingDecoder("io.airlift.compress.zstd.ZstdInputStream", "io.airlift.compress.v3.zstd.ZstdInputStream", "com.github.luben.zstd.ZstdInputStream"));
    }

    @FunctionalInterface
    public static interface DecoderProvider {
        @Nullable
        public InputStreamMapper get(String var1);
    }

    @FunctionalInterface
    public static interface InputStreamMapper {
        public InputStream map(InputStream var1) throws IOException;
    }
}

