/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.httpclient;

import java.io.IOException;
import java.net.CookieManager;
import java.net.ProtocolException;
import java.net.UnknownHostException;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.net.ssl.SSLException;
import net.lenni0451.commons.httpclient.HeaderStore;
import net.lenni0451.commons.httpclient.HttpRequestBuilder;
import net.lenni0451.commons.httpclient.HttpResponse;
import net.lenni0451.commons.httpclient.exceptions.RetryExceededException;
import net.lenni0451.commons.httpclient.executor.ExecutorType;
import net.lenni0451.commons.httpclient.executor.RequestExecutor;
import net.lenni0451.commons.httpclient.handler.HttpResponseHandler;
import net.lenni0451.commons.httpclient.proxy.ProxyHandler;
import net.lenni0451.commons.httpclient.requests.HttpRequest;
import net.lenni0451.commons.httpclient.retry.RetryAction;
import net.lenni0451.commons.httpclient.retry.RetryConfig;

public class HttpClient
extends HeaderStore<HttpClient>
implements HttpRequestBuilder {
    private RequestExecutor executor;
    @Nullable
    private CookieManager cookieManager = new CookieManager();
    private boolean followRedirects = true;
    private int connectTimeout = 10000;
    private int readTimeout = 10000;
    private RetryConfig retryConfig = new RetryConfig();
    private ProxyHandler proxyHandler = new ProxyHandler();
    private boolean ignoreInvalidSSL = false;

    public HttpClient() {
        this(ExecutorType.AUTO);
    }

    public HttpClient(@Nonnull ExecutorType executorType) {
        this(executorType::makeExecutor);
    }

    public HttpClient(@Nonnull Function<HttpClient, RequestExecutor> executorSupplier) {
        this.setExecutor(executorSupplier);
    }

    public HttpClient setExecutor(@Nonnull Function<HttpClient, RequestExecutor> executorSupplier) {
        RequestExecutor executor = executorSupplier.apply(this);
        if (executor == null) {
            throw new NullPointerException("The executor supplier returned null");
        }
        this.executor = executor;
        return this;
    }

    @Nullable
    public CookieManager getCookieManager() {
        return this.cookieManager;
    }

    public HttpClient setCookieManager(@Nullable CookieManager cookieManager) {
        this.cookieManager = cookieManager;
        return this;
    }

    public boolean isFollowRedirects() {
        return this.followRedirects;
    }

    public HttpClient setFollowRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
        return this;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public HttpClient setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public HttpClient setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    @Nonnull
    public RetryConfig getRetryHandler() {
        return this.retryConfig;
    }

    public HttpClient setRetryHandler(@Nonnull RetryConfig retryConfig) {
        this.retryConfig = retryConfig;
        return this;
    }

    @Nonnull
    public ProxyHandler getProxyHandler() {
        return this.proxyHandler;
    }

    public HttpClient setProxyHandler(@Nonnull ProxyHandler proxyHandler) {
        this.proxyHandler = proxyHandler;
        return this;
    }

    public boolean isIgnoreInvalidSSL() {
        return this.ignoreInvalidSSL;
    }

    public HttpClient setIgnoreInvalidSSL(boolean ignoreInvalidSSL) {
        this.ignoreInvalidSSL = ignoreInvalidSSL;
        return this;
    }

    public <T extends HttpRequest, R> R executeAndHandle(T requestAndHandler) throws IOException {
        return this.execute(requestAndHandler, (HttpResponseHandler)((Object)requestAndHandler));
    }

    public <R> R execute(HttpRequest request, HttpResponseHandler<R> responseHandler) throws IOException {
        return responseHandler.handle(this.execute(request));
    }

    public HttpResponse execute(HttpRequest request) throws IOException {
        RetryConfig retryConfig = request.isRetryHandlerSet() ? request.getRetryHandler() : this.retryConfig;
        for (int connects = 0; connects <= retryConfig.getMaxConnectRetries(); ++connects) {
            try {
                HttpResponse response = null;
                for (int headers = 0; headers <= retryConfig.getMaxResponseRetries(); ++headers) {
                    response = this.executor.execute(request);
                    RetryAction retryAction = retryConfig.getRetryHandler().shouldRetry(response);
                    if (!retryAction.shouldRetry()) {
                        return response;
                    }
                    retryAction.sleep();
                }
                if (response == null) {
                    throw new IllegalStateException("Response not received but no exception was thrown");
                }
                if (retryConfig.getMaxResponseRetries() == 0) {
                    return response;
                }
                throw new RetryExceededException(response);
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
            catch (ProtocolException | UnknownHostException | SSLException e) {
                throw e;
            }
            catch (IOException e) {
                if (connects < retryConfig.getMaxConnectRetries()) continue;
                throw e;
            }
        }
        throw new IllegalStateException("Connect retry failed but no exception was thrown");
    }

    @Override
    public <T extends HttpRequest> T bind(T request) {
        request.bind(this);
        return request;
    }

    public String toString() {
        return "HttpClient#" + this.executor.getClass().getSimpleName() + "@" + Integer.toHexString(System.identityHashCode(this));
    }
}

