/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.addons.noise.samplers.noise.fractal;

import com.dfsek.terra.addons.noise.samplers.noise.fractal.FractalNoiseFunction;
import com.dfsek.terra.api.noise.NoiseSampler;

public class PingPongSampler
extends FractalNoiseFunction {
    private double pingPongStrength = 2.0;

    public PingPongSampler(NoiseSampler input) {
        super(input);
    }

    private static double pingPong(double t) {
        return (t -= (double)((int)(t * 0.5) << 1)) < 1.0 ? t : 2.0 - t;
    }

    public void setPingPongStrength(double strength) {
        this.pingPongStrength = strength;
    }

    @Override
    public double getNoiseRaw(long seed, double x, double y) {
        double sum = 0.0;
        double amp = this.fractalBounding;
        for (int i = 0; i < this.octaves; ++i) {
            double noise = PingPongSampler.pingPong((this.input.noise(seed++, x, y) + 1.0) * this.pingPongStrength);
            sum += (noise - 0.5) * 2.0 * amp;
            amp *= PingPongSampler.lerp(1.0, noise, this.weightedStrength);
            x *= this.lacunarity;
            y *= this.lacunarity;
            amp *= this.gain;
        }
        return sum;
    }

    @Override
    public double getNoiseRaw(long seed, double x, double y, double z) {
        double sum = 0.0;
        double amp = this.fractalBounding;
        for (int i = 0; i < this.octaves; ++i) {
            double noise = PingPongSampler.pingPong((this.input.noise(seed++, x, y, z) + 1.0) * this.pingPongStrength);
            sum += (noise - 0.5) * 2.0 * amp;
            amp *= PingPongSampler.lerp(1.0, noise, this.weightedStrength);
            x *= this.lacunarity;
            y *= this.lacunarity;
            z *= this.lacunarity;
            amp *= this.gain;
        }
        return sum;
    }
}

