/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.addons.noise.normalizer;

import com.dfsek.terra.addons.noise.lib.jafama.FastMath;
import com.dfsek.terra.addons.noise.normalizer.Normalizer;
import com.dfsek.terra.api.noise.NoiseSampler;
import com.dfsek.terra.api.util.MathUtil;

public class NormalNormalizer
extends Normalizer {
    private final double[] lookup;

    public NormalNormalizer(NoiseSampler sampler, int buckets, double mean, double standardDeviation) {
        super(sampler);
        this.lookup = new double[buckets];
        for (int i = 0; i < buckets; ++i) {
            this.lookup[i] = MathUtil.normalInverse((double)((double)i / (double)buckets), (double)mean, (double)standardDeviation);
        }
    }

    @Override
    public double normalize(double in) {
        double right;
        int start = 0;
        int end = this.lookup.length - 1;
        while (start + 1 < end) {
            int mid = start + (end - start) / 2;
            if (this.lookup[mid] <= in) {
                start = mid;
                continue;
            }
            end = mid;
        }
        double left = FastMath.abs(this.lookup[start] - in);
        double fin = left <= (right = FastMath.abs(this.lookup[end] - in)) ? (double)start / (double)this.lookup.length : (double)end / (double)this.lookup.length;
        return (fin - 0.5) * 2.0;
    }
}

