/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.addons.noise.config.templates;

import com.dfsek.tectonic.api.config.template.annotations.Default;
import com.dfsek.tectonic.api.config.template.annotations.Value;
import com.dfsek.tectonic.api.exception.ValidationException;
import com.dfsek.terra.addons.noise.config.templates.SamplerTemplate;
import com.dfsek.terra.addons.noise.samplers.KernelSampler;
import com.dfsek.terra.api.config.meta.Meta;
import com.dfsek.terra.api.noise.NoiseSampler;
import java.util.List;

public class KernelTemplate
extends SamplerTemplate<KernelSampler> {
    @Value(value="kernel")
    private @Meta List<@Meta List<@Meta Double>> kernel;
    @Value(value="factor")
    @Default
    private @Meta double factor = 1.0;
    @Value(value="sampler")
    private @Meta NoiseSampler function;
    @Value(value="frequency")
    @Default
    private @Meta double frequency = 1.0;

    public NoiseSampler get() {
        double[][] k = new double[this.kernel.size()][this.kernel.get(0).size()];
        for (int x = 0; x < this.kernel.size(); ++x) {
            for (int y = 0; y < this.kernel.get(x).size(); ++y) {
                k[x][y] = this.kernel.get(x).get(y) * this.factor;
            }
        }
        KernelSampler sampler = new KernelSampler(k, this.function);
        sampler.setFrequency(this.frequency);
        return sampler;
    }

    @Override
    public boolean validate() throws ValidationException {
        if (this.kernel.isEmpty()) {
            throw new ValidationException("Kernel must not be empty.");
        }
        int len = this.kernel.get(0).size();
        if (len == 0) {
            throw new ValidationException("Kernel row must contain data.");
        }
        for (int i = 0; i < this.kernel.size(); ++i) {
            if (this.kernel.get(i).size() == len) continue;
            throw new ValidationException("Kernel row " + i + " size mismatch. Expected " + len + ", found " + this.kernel.get(i).size());
        }
        return super.validate();
    }
}

