/*
 * Decompiled with CFR 0.152.
 */
package net.coreprotect.worldedit;

import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.extent.AbstractDelegateExtent;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockType;
import net.coreprotect.config.Config;
import net.coreprotect.utility.ItemUtils;
import net.coreprotect.worldedit.CoreProtectEditSessionEvent;
import net.coreprotect.worldedit.WorldEditLogger;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class CoreProtectLogger
extends AbstractDelegateExtent {
    private final Actor eventActor;
    private final World eventWorld;
    private final Extent eventExtent;

    protected CoreProtectLogger(Actor actor, World world, Extent extent) {
        super(extent);
        this.eventActor = actor;
        this.eventWorld = world;
        this.eventExtent = extent;
    }

    public <T extends BlockStateHolder<T>> boolean setBlock(BlockVector3 position, T block) throws WorldEditException {
        ItemStack[] containerData;
        org.bukkit.World world = BukkitAdapter.adapt((World)this.eventWorld);
        if (!Config.getConfig((org.bukkit.World)world).WORLDEDIT) {
            if (CoreProtectEditSessionEvent.isFAWE()) {
                return this.eventExtent.setBlock(position.getX(), position.getY(), position.getZ(), block);
            }
            return this.eventExtent.setBlock(position, block);
        }
        BlockState oldBlock = this.eventExtent.getBlock(position);
        Material oldType = BukkitAdapter.adapt((BlockType)oldBlock.getBlockType());
        Location location = new Location(world, (double)position.getBlockX(), (double)position.getBlockY(), (double)position.getBlockZ());
        BaseBlock baseBlock = WorldEditLogger.getBaseBlock(this.eventExtent, position, location, oldType, oldBlock);
        ItemStack[] itemStackArray = containerData = CoreProtectEditSessionEvent.isFAWE() ? null : ItemUtils.getContainerContents(oldType, null, location);
        if (CoreProtectEditSessionEvent.isFAWE()) {
            if (this.eventExtent.setBlock(position.getX(), position.getY(), position.getZ(), block)) {
                WorldEditLogger.postProcess(this.eventExtent, this.eventActor, position, location, block, baseBlock, oldType, oldBlock, containerData);
                return true;
            }
        } else if (this.eventExtent.setBlock(position, block)) {
            WorldEditLogger.postProcess(this.eventExtent, this.eventActor, position, location, block, baseBlock, oldType, oldBlock, containerData);
            return true;
        }
        return false;
    }

    public <T extends BlockStateHolder<T>> boolean setBlock(int x, int y, int z, T block) throws WorldEditException {
        return this.setBlock(BlockVector3.at((int)x, (int)y, (int)z), block);
    }

    public int replaceBlocks(Region region, Mask mask, Pattern pattern) throws MaxChangedBlocksException {
        org.bukkit.World world = BukkitAdapter.adapt((World)this.eventWorld);
        if (!Config.getConfig((org.bukkit.World)world).WORLDEDIT) {
            return this.eventExtent.replaceBlocks(region, mask, pattern);
        }
        this.processPatternToBlocks(world, region, pattern);
        return this.eventExtent.replaceBlocks(region, mask, pattern);
    }

    public int setBlocks(Region region, Pattern pattern) throws MaxChangedBlocksException {
        org.bukkit.World world = BukkitAdapter.adapt((World)this.eventWorld);
        if (!Config.getConfig((org.bukkit.World)world).WORLDEDIT) {
            return this.eventExtent.setBlocks(region, pattern);
        }
        this.processPatternToBlocks(world, region, pattern);
        return this.eventExtent.setBlocks(region, pattern);
    }

    private void processPatternToBlocks(org.bukkit.World world, Region region, Pattern pattern) {
        for (BlockVector3 position : region.clone()) {
            BlockState oldBlock = this.eventExtent.getBlock(position);
            Material oldType = BukkitAdapter.adapt((BlockType)oldBlock.getBlockType());
            Location location = new Location(world, (double)position.getBlockX(), (double)position.getBlockY(), (double)position.getBlockZ());
            BaseBlock baseBlock = WorldEditLogger.getBaseBlock(this.eventExtent, position, location, oldType, oldBlock);
            ItemStack[] containerData = CoreProtectEditSessionEvent.isFAWE() ? null : ItemUtils.getContainerContents(oldType, null, location);
            WorldEditLogger.postProcess(this.eventExtent, this.eventActor, position, location, pattern.applyBlock(position), baseBlock, oldType, oldBlock, containerData);
        }
    }
}

