/*
 * Decompiled with CFR 0.152.
 */
package net.coreprotect.utility.entity;

import java.util.Locale;
import net.coreprotect.bukkit.BukkitAdapter;
import net.coreprotect.model.BlockGroup;
import net.coreprotect.utility.BlockUtils;
import net.coreprotect.utility.MaterialUtils;
import org.bukkit.Art;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Painting;
import org.bukkit.inventory.ItemStack;

public class HangingUtil {
    private HangingUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static void spawnHanging(BlockState blockstate, Material rowType, String hangingData, int rowData) {
        block38: {
            try {
                Block block = blockstate.getBlock();
                int x = block.getX();
                int y = block.getY();
                int z = block.getZ();
                BlockFace hangingFace = null;
                if (hangingData != null && !hangingData.contains(":") && hangingData.contains("=")) {
                    try {
                        hangingFace = BlockFace.valueOf((String)hangingData.split("=")[1].toUpperCase(Locale.ROOT));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                for (Entity e : block.getChunk().getEntities()) {
                    Location el;
                    if ((!BukkitAdapter.ADAPTER.isItemFrame(rowType) || !(e instanceof ItemFrame)) && (!rowType.equals((Object)Material.PAINTING) || !(e instanceof Painting)) || (el = e.getLocation()).getBlockX() != x || el.getBlockY() != y || el.getBlockZ() != z || hangingFace != null && ((Hanging)e).getFacing() != hangingFace) continue;
                    e.remove();
                    break;
                }
                BlockFace faceSet = null;
                BlockFace face = null;
                if (hangingFace == null) {
                    Block c1 = block.getWorld().getBlockAt(x + 1, y, z);
                    Block c2 = block.getWorld().getBlockAt(x - 1, y, z);
                    Block c3 = block.getWorld().getBlockAt(x, y, z + 1);
                    Block c4 = block.getWorld().getBlockAt(x, y, z - 1);
                    if (!BlockGroup.NON_ATTACHABLE.contains(c1.getType())) {
                        faceSet = BlockFace.WEST;
                        block = c1;
                    } else if (!BlockGroup.NON_ATTACHABLE.contains(c2.getType())) {
                        faceSet = BlockFace.EAST;
                        block = c2;
                    } else if (!BlockGroup.NON_ATTACHABLE.contains(c3.getType())) {
                        faceSet = BlockFace.NORTH;
                        block = c3;
                    } else if (!BlockGroup.NON_ATTACHABLE.contains(c4.getType())) {
                        faceSet = BlockFace.SOUTH;
                        block = c4;
                    }
                    if (!BlockUtils.solidBlock(BlockUtils.getType(block.getRelative(BlockFace.EAST)))) {
                        face = BlockFace.EAST;
                    } else if (!BlockUtils.solidBlock(BlockUtils.getType(block.getRelative(BlockFace.NORTH)))) {
                        face = BlockFace.NORTH;
                    } else if (!BlockUtils.solidBlock(BlockUtils.getType(block.getRelative(BlockFace.WEST)))) {
                        face = BlockFace.WEST;
                    } else if (!BlockUtils.solidBlock(BlockUtils.getType(block.getRelative(BlockFace.SOUTH)))) {
                        face = BlockFace.SOUTH;
                    }
                } else {
                    faceSet = hangingFace;
                    face = hangingFace;
                }
                if (faceSet == null || face == null) break block38;
                if (rowType.equals((Object)Material.PAINTING)) {
                    Block spawnBlock;
                    String name = MaterialUtils.getArtName(rowData);
                    Art painting = Art.getByName((String)name.toUpperCase(Locale.ROOT));
                    int height = painting.getBlockHeight();
                    int width = painting.getBlockWidth();
                    int paintingX = x;
                    int paintingY = y;
                    int paintingZ = z;
                    if (height != 1 || width != 1) {
                        if (height > 1 && height != 3) {
                            --paintingY;
                        }
                        if (width > 1) {
                            if (faceSet.equals((Object)BlockFace.WEST)) {
                                --paintingZ;
                            } else if (faceSet.equals((Object)BlockFace.SOUTH)) {
                                --paintingX;
                            }
                        }
                    }
                    Block block2 = spawnBlock = hangingFace != null ? block : block.getRelative(face);
                    if (hangingFace == null) {
                        BlockUtils.setTypeAndData(spawnBlock, Material.AIR, null, true);
                    }
                    Painting hanging = null;
                    try {
                        hanging = (Painting)block.getWorld().spawn(spawnBlock.getLocation(), Painting.class);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (hanging != null) {
                        hanging.teleport(block.getWorld().getBlockAt(paintingX, paintingY, paintingZ).getLocation());
                        hanging.setFacingDirection(faceSet, true);
                        hanging.setArt(painting, true);
                    }
                    break block38;
                }
                if (!BukkitAdapter.ADAPTER.isItemFrame(rowType)) break block38;
                try {
                    Block spawnBlock;
                    Block block3 = spawnBlock = hangingFace != null ? block : block.getRelative(face);
                    if (hangingFace == null) {
                        BlockUtils.setTypeAndData(spawnBlock, Material.AIR, null, true);
                    }
                    Class<?> itemFrame = BukkitAdapter.ADAPTER.getFrameClass(rowType);
                    Entity entity = block.getWorld().spawn(spawnBlock.getLocation(), itemFrame);
                    if (entity instanceof ItemFrame) {
                        ItemFrame hanging = (ItemFrame)entity;
                        hanging.teleport(block.getWorld().getBlockAt(x, y, z).getLocation());
                        hanging.setFacingDirection(faceSet, true);
                        Material type = MaterialUtils.getType(rowData);
                        if (type != null) {
                            ItemStack istack = new ItemStack(type, 1);
                            hanging.setItem(istack);
                        }
                    }
                }
                catch (Exception exception) {}
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void removeHanging(BlockState block, String hangingData) {
        try {
            BlockFace hangingFace = null;
            if (hangingData != null && !hangingData.contains(":") && hangingData.contains("=")) {
                try {
                    hangingFace = BlockFace.valueOf((String)hangingData.split("=")[1].toUpperCase(Locale.ROOT));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            for (Entity e : block.getChunk().getEntities()) {
                Location el;
                if (!(e instanceof ItemFrame) && !(e instanceof Painting) || (el = e.getLocation()).getBlockX() != block.getX() || el.getBlockY() != block.getY() || el.getBlockZ() != block.getZ() || hangingFace != null && ((Hanging)e).getFacing() != hangingFace) continue;
                e.remove();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

