/*
 * Decompiled with CFR 0.152.
 */
package net.coreprotect.utility;

import net.coreprotect.CoreProtect;
import net.coreprotect.thread.Scheduler;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.type.Chest;

public class ChestTool {
    private ChestTool() {
        throw new IllegalStateException("Utility class");
    }

    public static void updateDoubleChest(Block block, BlockData blockData, boolean forceValidation) {
        if (!(blockData instanceof Chest) || ((Chest)blockData).getType() == Chest.Type.SINGLE) {
            return;
        }
        Directional directional = (Directional)blockData;
        BlockFace blockFace = directional.getFacing();
        BlockFace newFace = null;
        Chest.Type chestType = ((Chest)blockData).getType();
        if (chestType == Chest.Type.LEFT) {
            switch (blockFace) {
                case NORTH: {
                    newFace = BlockFace.EAST;
                    break;
                }
                case WEST: {
                    newFace = BlockFace.NORTH;
                    break;
                }
                case EAST: {
                    newFace = BlockFace.SOUTH;
                    break;
                }
                case SOUTH: {
                    newFace = BlockFace.WEST;
                    break;
                }
            }
        } else if (chestType == Chest.Type.RIGHT) {
            switch (blockFace) {
                case NORTH: {
                    newFace = BlockFace.WEST;
                    break;
                }
                case WEST: {
                    newFace = BlockFace.SOUTH;
                    break;
                }
                case EAST: {
                    newFace = BlockFace.NORTH;
                    break;
                }
                case SOUTH: {
                    newFace = BlockFace.EAST;
                    break;
                }
            }
        }
        if (newFace != null) {
            Chest.Type newType = chestType == Chest.Type.LEFT ? Chest.Type.RIGHT : Chest.Type.LEFT;
            Block relativeBlock = block.getRelative(newFace);
            if (!forceValidation && relativeBlock.getBlockData() instanceof Chest && ((Chest)relativeBlock.getBlockData()).getType() == newType) {
                return;
            }
            ChestTool.validateContainer(blockData, newType, block, relativeBlock);
        }
    }

    private static void validateContainer(BlockData blockData, Chest.Type newType, Block block, Block relativeBlock) {
        Scheduler.scheduleSyncDelayedTask(CoreProtect.getInstance(), () -> {
            try {
                BlockData relativeBlockData = relativeBlock.getBlockData();
                if (!blockData.getAsString().equals(block.getBlockData().getAsString()) || !(relativeBlockData instanceof Chest) || ((Chest)relativeBlockData).getType() == newType) {
                    return;
                }
                Chest chestData = (Chest)blockData;
                chestData.setType(newType);
                relativeBlock.setBlockData((BlockData)chestData, true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }, relativeBlock.getLocation(), 2);
    }
}

