/*
 * Decompiled with CFR 0.152.
 */
package net.coreprotect.utility;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.coreprotect.CoreProtect;
import net.coreprotect.bukkit.BukkitAdapter;
import net.coreprotect.thread.CacheHandler;
import net.coreprotect.thread.Scheduler;
import net.coreprotect.utility.ItemUtils;
import net.coreprotect.utility.MaterialUtils;
import net.coreprotect.utility.WorldUtils;
import org.bukkit.Material;
import org.bukkit.block.Banner;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.block.CommandBlock;
import org.bukkit.block.Jukebox;
import org.bukkit.block.ShulkerBox;
import org.bukkit.block.banner.Pattern;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Waterlogged;
import org.bukkit.inventory.BlockInventoryHolder;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class BlockUtils {
    private static final String NAMESPACE = "minecraft:";

    private BlockUtils() {
        throw new IllegalStateException("Utility class");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static byte[] stringToByteData(String string, int type) {
        byte[] result = null;
        if (string == null) return result;
        Material material = MaterialUtils.getType(type);
        if (material == null) {
            return result;
        }
        if (material.isBlock() && !BlockUtils.createBlockData(material).getAsString().equals(string) && string.startsWith(NAMESPACE + material.name().toLowerCase(Locale.ROOT) + "[") && string.endsWith("]")) {
            String substring = string.substring(material.name().length() + 11, string.length() - 1);
            String[] blockDataSplit = substring.split(",");
            ArrayList<String> blockDataArray = new ArrayList<String>();
            for (String data : blockDataSplit) {
                int id = MaterialUtils.getBlockdataId(data, true);
                if (id <= -1) continue;
                blockDataArray.add(Integer.toString(id));
            }
            string = String.join((CharSequence)",", blockDataArray);
            return string.getBytes(StandardCharsets.UTF_8);
        } else {
            int id;
            if (string.contains(":")) return result;
            if (material != Material.PAINTING) {
                if (!BukkitAdapter.ADAPTER.isItemFrame(material)) return result;
            }
            if ((id = MaterialUtils.getBlockdataId(string, true)) <= -1) return result;
            string = Integer.toString(id);
        }
        return string.getBytes(StandardCharsets.UTF_8);
    }

    public static String byteDataToString(byte[] data, int type) {
        Object result = "";
        if (data != null) {
            Material material = MaterialUtils.getType(type);
            if (material == null) {
                return result;
            }
            result = new String(data, StandardCharsets.UTF_8);
            if (((String)result).length() > 0) {
                if (((String)result).matches("\\d+")) {
                    result = (String)result + ",";
                }
                if (((String)result).contains(",")) {
                    String[] blockDataSplit = ((String)result).split(",");
                    ArrayList<String> blockDataArray = new ArrayList<String>();
                    for (String blockData : blockDataSplit) {
                        String block = MaterialUtils.getBlockDataString(Integer.parseInt(blockData));
                        if (block.length() <= 0) continue;
                        blockDataArray.add(block);
                    }
                    result = material == Material.PAINTING || BukkitAdapter.ADAPTER.isItemFrame(material) ? String.join((CharSequence)",", blockDataArray) : NAMESPACE + material.name().toLowerCase(Locale.ROOT) + "[" + String.join((CharSequence)",", blockDataArray) + "]";
                } else {
                    result = "";
                }
            }
        }
        return result;
    }

    public static Waterlogged checkWaterlogged(BlockData blockData, BlockState blockReplacedState) {
        if (blockReplacedState.getType().equals((Object)Material.WATER) && blockData instanceof Waterlogged && blockReplacedState.getBlockData().equals((Object)Material.WATER.createBlockData())) {
            Waterlogged waterlogged = (Waterlogged)blockData;
            waterlogged.setWaterlogged(true);
            return waterlogged;
        }
        return null;
    }

    public static boolean isAir(Material type) {
        return type == Material.AIR || type == Material.CAVE_AIR || type == Material.VOID_AIR;
    }

    public static boolean solidBlock(Material type) {
        return type.isSolid();
    }

    public static boolean passableBlock(Block block) {
        return block.isPassable();
    }

    public static Material getType(Block block) {
        return block.getType();
    }

    public static boolean iceBreakCheck(BlockState block, String user, Material type) {
        if (type.equals((Object)Material.ICE)) {
            int unixtimestamp = (int)(System.currentTimeMillis() / 1000L);
            int wid = WorldUtils.getWorldId(block.getWorld().getName());
            CacheHandler.lookupCache.put(block.getX() + "." + block.getY() + "." + block.getZ() + "." + wid, new Object[]{unixtimestamp, user, Material.WATER});
            return true;
        }
        return false;
    }

    public static BlockData createBlockData(Material material) {
        try {
            BlockData result = material.createBlockData();
            if (result instanceof Waterlogged) {
                ((Waterlogged)result).setWaterlogged(false);
            }
            return result;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void prepareTypeAndData(Map<Block, BlockData> map, Block block, Material type, BlockData blockData, boolean update) {
        if (blockData == null) {
            blockData = BlockUtils.createBlockData(type);
        }
        if (!update) {
            BlockUtils.setTypeAndData(block, type, blockData, update);
            map.remove(block);
        } else {
            map.put(block, blockData);
        }
    }

    public static void setTypeAndData(Block block, Material type, BlockData blockData, boolean update) {
        if (blockData == null && type != null) {
            blockData = BlockUtils.createBlockData(type);
        }
        if (blockData != null) {
            block.setBlockData(blockData, update);
        }
    }

    public static void updateBlock(BlockState block) {
        Scheduler.runTask(CoreProtect.getInstance(), () -> {
            try {
                Block currentBlock;
                if (block.getBlockData() instanceof Waterlogged && (currentBlock = block.getBlock()).getType().equals((Object)block.getType())) {
                    block.setBlockData(currentBlock.getBlockData());
                }
                block.update();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }, block.getLocation());
    }

    public static Inventory getContainerInventory(BlockState blockState, boolean singleBlock) {
        Inventory inventory = null;
        try {
            if (blockState instanceof BlockInventoryHolder) {
                if (singleBlock) {
                    ArrayList<Material> chests = new ArrayList<Material>(Arrays.asList(Material.CHEST, Material.TRAPPED_CHEST));
                    chests.addAll(BukkitAdapter.ADAPTER.copperChestMaterials());
                    Material type = blockState.getType();
                    if (chests.contains(type)) {
                        inventory = ((Chest)blockState).getBlockInventory();
                    }
                }
                if (inventory == null) {
                    inventory = ((BlockInventoryHolder)blockState).getInventory();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return inventory;
    }

    public static List<Object> processMeta(BlockState block) {
        ArrayList<Object> meta = new ArrayList<Object>();
        try {
            if (block instanceof CommandBlock) {
                CommandBlock commandBlock = (CommandBlock)block;
                String command = commandBlock.getCommand();
                if (command.length() > 0) {
                    meta.add(command);
                }
            } else if (block instanceof Banner) {
                Banner banner = (Banner)block;
                meta.add(banner.getBaseColor());
                List patterns = banner.getPatterns();
                for (Pattern pattern : patterns) {
                    meta.add(pattern.serialize());
                }
            } else if (block instanceof ShulkerBox) {
                ShulkerBox shulkerBox = (ShulkerBox)block;
                ItemStack[] inventory = shulkerBox.getSnapshotInventory().getStorageContents();
                int slot = 0;
                for (ItemStack itemStack : inventory) {
                    Map<Integer, Object> itemMap = ItemUtils.serializeItemStackLegacy(itemStack, null, slot);
                    if (itemMap.size() > 0) {
                        meta.add(itemMap);
                    }
                    ++slot;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (meta.isEmpty()) {
            meta = null;
        }
        return meta;
    }

    public static ItemStack[] getJukeboxItem(Jukebox blockState) {
        ItemStack[] contents = null;
        try {
            contents = new ItemStack[]{blockState.getRecord()};
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return contents;
    }

    public static int getSignData(boolean frontGlowing, boolean backGlowing) {
        if (frontGlowing && backGlowing) {
            return 3;
        }
        if (backGlowing) {
            return 2;
        }
        if (frontGlowing) {
            return 1;
        }
        return 0;
    }

    public static boolean isSideGlowing(boolean isFront, int data) {
        return isFront && (data == 1 || data == 3) || !isFront && (data == 2 || data == 3);
    }
}

