/*
 * Decompiled with CFR 0.152.
 */
package net.coreprotect.services;

import java.io.File;
import net.coreprotect.CoreProtect;
import net.coreprotect.bukkit.Metrics;
import net.coreprotect.command.CommandHandler;
import net.coreprotect.command.TabHandler;
import net.coreprotect.config.Config;
import net.coreprotect.config.ConfigHandler;
import net.coreprotect.consumer.Consumer;
import net.coreprotect.language.Language;
import net.coreprotect.language.Phrase;
import net.coreprotect.listener.ListenerHandler;
import net.coreprotect.services.VersionCheckService;
import net.coreprotect.thread.CacheHandler;
import net.coreprotect.thread.NetworkHandler;
import net.coreprotect.thread.Scheduler;
import net.coreprotect.utility.Chat;
import net.coreprotect.utility.ChatUtils;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.java.JavaPlugin;

public class PluginInitializationService {
    private PluginInitializationService() {
        throw new IllegalStateException("Utility class");
    }

    public static boolean initializePlugin(CoreProtect plugin) {
        Language.loadPhrases();
        boolean start = VersionCheckService.performVersionChecks();
        if (!start) {
            return false;
        }
        try {
            Consumer.initialize();
            new ListenerHandler(plugin);
            PluginInitializationService.registerCommands(plugin);
            PluginInitializationService.createDataDirectory();
            start = ConfigHandler.performInitialization(true);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        if (start) {
            PluginInitializationService.displayStartupMessages(plugin);
            PluginInitializationService.startBackgroundServices(plugin);
            PluginInitializationService.enableMetrics(plugin);
        }
        return start;
    }

    private static void registerCommands(JavaPlugin plugin) {
        plugin.getCommand("coreprotect").setExecutor((CommandExecutor)CommandHandler.getInstance());
        plugin.getCommand("coreprotect").setTabCompleter((TabCompleter)new TabHandler());
        plugin.getCommand("core").setExecutor((CommandExecutor)CommandHandler.getInstance());
        plugin.getCommand("core").setTabCompleter((TabCompleter)new TabHandler());
        plugin.getCommand("co").setExecutor((CommandExecutor)CommandHandler.getInstance());
        plugin.getCommand("co").setTabCompleter((TabCompleter)new TabHandler());
    }

    private static void createDataDirectory() {
        boolean exists = new File(ConfigHandler.path).exists();
        if (!exists) {
            new File(ConfigHandler.path).mkdir();
        }
    }

    private static void displayStartupMessages(JavaPlugin plugin) {
        PluginDescriptionFile pluginDescription = plugin.getDescription();
        ChatUtils.sendConsoleComponentStartup(Bukkit.getServer().getConsoleSender(), Phrase.build(Phrase.ENABLE_SUCCESS, ConfigHandler.EDITION_NAME));
        if (Config.getGlobal().MYSQL) {
            Chat.console(Phrase.build(Phrase.USING_MYSQL, new String[0]));
        } else {
            Chat.console(Phrase.build(Phrase.USING_SQLITE, new String[0]));
        }
        Chat.console("--------------------");
        Chat.console(Phrase.build(Phrase.ENJOY_COREPROTECT, pluginDescription.getName()));
        Chat.console(Phrase.build(Phrase.LINK_DISCORD, "www.coreprotect.net/discord/"));
        Chat.console("--------------------");
    }

    private static void startBackgroundServices(CoreProtect plugin) {
        Scheduler.scheduleSyncDelayedTask(plugin, () -> {
            try {
                Thread networkHandler = new Thread(new NetworkHandler(true, true));
                networkHandler.start();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }, 0);
        Thread cacheCleanUpThread = new Thread(new CacheHandler());
        cacheCleanUpThread.start();
        Consumer.startConsumer();
    }

    private static void enableMetrics(JavaPlugin plugin) {
        try {
            new Metrics(plugin, 2876);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

